/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.forge.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.fml.ModList;

public class ModLoadedLootTable
implements LootItemCondition {
    public static final LootItemConditionType TYPE = new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    private final String id;
    private final boolean isLoaded;

    private ModLoadedLootTable(String id, boolean isLoaded) {
        this.id = id;
        this.isLoaded = isLoaded;
    }

    public LootItemConditionType m_7940_() {
        return TYPE;
    }

    public boolean test(LootContext lootContext) {
        return this.isLoaded == ModList.get().isLoaded(this.id);
    }

    public static Builder builder(String id, boolean isLoaded) {
        return new Builder(id, isLoaded);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final String id;
        private final boolean isLoaded;

        public Builder(String id, boolean isLoaded) {
            if (id == null) {
                throw new IllegalArgumentException("Target loot table must not be null");
            }
            this.id = id;
            this.isLoaded = isLoaded;
        }

        public LootItemCondition m_6409_() {
            return new ModLoadedLootTable(this.id, this.isLoaded);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ModLoadedLootTable> {
        public void serialize(JsonObject object, ModLoadedLootTable instance, JsonSerializationContext ctx) {
            object.addProperty("mod", instance.id);
            object.addProperty("is_mod_loaded", Boolean.valueOf(instance.isLoaded));
        }

        public ModLoadedLootTable deserialize(JsonObject object, JsonDeserializationContext ctx) {
            return new ModLoadedLootTable(GsonHelper.m_13906_((JsonObject)object, (String)"mod"), GsonHelper.m_13912_((JsonObject)object, (String)"is_mod_loaded"));
        }
    }
}

