/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.forge;

import java.nio.file.Path;
import net.artienia.rubinated_nether.RubinatedNether;
import net.artienia.rubinated_nether.forge.conditions.ModLoadedLootTable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="rubinated_nether")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class RubinatedNetherForge {
    public RubinatedNetherForge() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)RubinatedNether.REGISTRIES);
        RubinatedNether.init();
    }

    @SubscribeEvent
    public static void onSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(RubinatedNether::setup);
    }

    @SubscribeEvent
    public void registerLootData(RegisterEvent event) {
        if (!event.getRegistryKey().equals((Object)Registries.f_256976_)) {
            return;
        }
        event.register(Registries.f_256976_, new ResourceLocation("rubinated_nether", "is_mod_loaded"), () -> ModLoadedLootTable.TYPE);
    }

    @SubscribeEvent
    public static void addResourcePack(AddPackFindersEvent event) {
        IModFile modFile = ModList.get().getModFileById("rubinated_nether").getFile();
        RubinatedNetherForge.createPack(event, modFile, "better_netherite_template", "Better Netherite Template", false);
        if (ModList.get().isLoaded("spelunkery")) {
            RubinatedNetherForge.createPack(event, modFile, "compat_spelunkery", "Rubinated Nether Spelunkery Compat", true);
        }
    }

    private static void createPack(AddPackFindersEvent event, IModFile modFile, String id, String name, boolean required) {
        Path resourcePath = modFile.findResource(new String[]{"resourcepacks/" + id});
        Pack pack = Pack.m_245429_((String)("rubinated_nether/" + id), (Component)Component.m_237113_((String)name), (boolean)required, path -> new PathPackResources(path, resourcePath, true), (PackType)event.getPackType(), (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
        if (pack != null) {
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
    }
}

