/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.content.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.artienia.rubinated_nether.content.recipe.ModBookCategory;
import net.artienia.rubinated_nether.content.recipe.freezing.FreezingRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class ModCookingSerializer<T extends FreezingRecipe>
implements RecipeSerializer<T> {
    private final int defaultCookingTime;
    private final CookieBaker<T> factory;

    public ModCookingSerializer(CookieBaker<T> factory, int defaultCookingTime) {
        this.defaultCookingTime = defaultCookingTime;
        this.factory = factory;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        ItemStack result;
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        ModBookCategory modBookCategory = (ModBookCategory)ModBookCategory.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)ModBookCategory.UNKNOWN);
        JsonArray ingredientJson = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientJson);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        } else {
            String resultString = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            ResourceLocation resultLocation = new ResourceLocation(resultString);
            result = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(resultLocation));
            if (result.m_41619_()) {
                throw new IllegalStateException("Item: " + resultString + " does not exist");
            }
        }
        float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        int cookingTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.factory.create(id, group, modBookCategory, ingredient, result, experience, cookingTime);
    }

    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String group = buffer.m_130277_();
        ModBookCategory ModBookCategory2 = (ModBookCategory)buffer.m_130066_(ModBookCategory.class);
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack result = buffer.m_130267_();
        float experience = buffer.readFloat();
        int cookingTime = buffer.m_130242_();
        return this.factory.create(id, group, ModBookCategory2, ingredient, result, experience, cookingTime);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130070_(recipe.m_6076_());
        buffer.m_130068_((Enum)((FreezingRecipe)((Object)recipe)).modCategory());
        ((Ingredient)((FreezingRecipe)((Object)recipe)).m_7527_().get(0)).m_43923_(buffer);
        buffer.m_130055_(((FreezingRecipe)((Object)recipe)).getResult());
        buffer.writeFloat(recipe.m_43750_());
        buffer.m_130130_(recipe.m_43753_());
    }

    public static interface CookieBaker<T extends FreezingRecipe> {
        public T create(ResourceLocation var1, String var2, ModBookCategory var3, Ingredient var4, ItemStack var5, float var6, int var7);
    }
}

