/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.content.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import net.artienia.rubinated_nether.content.RNLootConditions;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record ItemTierLootCondition(int minLevel, int maxLevel) implements LootItemCondition
{
    public static LootItemConditionType createType() {
        return new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    }

    public static Builder builder() {
        return new Builder();
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)RNLootConditions.ITEM_TIER.get();
    }

    public boolean test(LootContext lootContext) {
        TieredItem tiered;
        int level;
        ItemStack stack = (ItemStack)lootContext.m_165124_(LootContextParams.f_81463_);
        Item item = stack.m_41720_();
        return item instanceof TieredItem && (level = (tiered = (TieredItem)item).m_43314_().m_6604_()) <= this.maxLevel && level >= this.minLevel;
    }

    private static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ItemTierLootCondition> {
        private Serializer() {
        }

        public void serialize(JsonObject json, ItemTierLootCondition value, JsonSerializationContext serializationContext) {
            json.add("min_level", (JsonElement)new JsonPrimitive((Number)value.minLevel));
            json.add("max_level", (JsonElement)new JsonPrimitive((Number)value.maxLevel));
        }

        public ItemTierLootCondition deserialize(JsonObject json, JsonDeserializationContext serializationContext) {
            return new ItemTierLootCondition(json.get("min_level").getAsInt(), json.get("max_level").getAsInt());
        }
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private int minLevel;
        private int maxLevel = Integer.MAX_VALUE;

        private Builder() {
        }

        public Builder minTier(int tierLevel) {
            this.minLevel = tierLevel;
            return this;
        }

        public Builder minTier(Tier tier) {
            return this.minTier(tier.m_6604_());
        }

        public Builder maxTier(int tierLevel) {
            this.maxLevel = tierLevel;
            return this;
        }

        public Builder maxTier(Tier tier) {
            return this.maxTier(tier.m_6604_());
        }

        @NotNull
        public ItemTierLootCondition build() {
            return new ItemTierLootCondition(this.minLevel, this.maxLevel);
        }
    }
}

