/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.content.block.ruby_laser;

import java.util.Map;
import java.util.stream.Stream;
import net.artienia.rubinated_nether.content.RNBlocks;
import net.artienia.rubinated_nether.content.RNTags;
import net.artienia.rubinated_nether.content.block.ruby_laser.RubyLaserBlock;
import net.artienia.rubinated_nether.platform.Platform;
import net.artienia.rubinated_nether.utils.BlockUpdateListener;
import net.artienia.rubinated_nether.utils.ShapeUtils;
import net.artienia.rubinated_nether.utils.UpdateListenerHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableDouble;
import uwu.serenity.critter.utils.TickableBlockEntity;

public class RubyLaserBlockEntity
extends BlockEntity
implements BlockUpdateListener,
TickableBlockEntity {
    private static final Map<Direction, VoxelShape> BEAM_SEGMENT_SHAPES = ShapeUtils.allDirections(Shapes.m_83048_((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)1.0, (double)0.6));
    private int powerLevel;
    private int blockRange = -1;
    private int currentLaserRange = 15;
    private double rangeRemnant;
    private boolean visible = false;
    private float[] color;
    private boolean silly = false;

    public RubyLaserBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void m_142339_(Level level) {
        if (!this.m_58898_()) {
            UpdateListenerHolder.addUpdateListener(level, this);
        }
        super.m_142339_(level);
    }

    public void clientTick() {
        if (this.blockRange == -1) {
            this.handleBlockUpdate(this.f_58857_, this.f_58858_, this.m_58900_());
        }
    }

    public void tick() {
        if (this.blockRange == -1) {
            this.handleBlockUpdate(this.f_58857_, this.f_58858_, this.m_58900_());
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)RubyLaserBlock.TINTED)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)RubyLaserBlock.f_52588_);
        Vec3i rangeVec = facing.m_122436_().m_142393_(this.blockRange);
        AABB range = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82363_((double)rangeVec.m_123341_(), (double)rangeVec.m_123342_(), (double)rangeVec.m_123343_()).m_82338_(this.f_58858_.m_121945_(facing));
        MutableDouble lastDistance = new MutableDouble((double)this.blockRange);
        this.f_58857_.m_142646_().m_142232_(range, entity -> {
            double distance = Math.sqrt(entity.m_20275_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_())) - 1.0;
            if (distance < lastDistance.getValue()) {
                lastDistance.setValue(distance);
            }
        });
        int blockDistance = Mth.m_14045_((int)Mth.m_14107_((double)lastDistance.getValue()), (int)0, (int)this.currentLaserRange);
        this.powerLevel = this.currentLaserRange - blockDistance;
        if (this.powerLevel != (Integer)this.m_58900_().m_61143_((Property)RubyLaserBlock.POWER)) {
            this.f_58857_.m_186460_(this.m_58899_(), (Block)RNBlocks.RUBY_LASER.get(), 2);
        }
    }

    @Override
    public void handleBlockUpdate(Level view, BlockPos pos, BlockState bs) {
        this.currentLaserRange = 15;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)RubyLaserBlock.f_52588_);
        BlockPos.MutableBlockPos mutableBlockPos = this.f_58858_.m_122032_();
        this.blockRange = 0;
        for (int i = 0; i <= 15; ++i) {
            VoxelShape shape;
            mutableBlockPos.m_122173_(facing);
            this.blockRange = i;
            BlockState state = this.f_58857_.m_8055_((BlockPos)mutableBlockPos);
            boolean blocks = state.m_204336_(RNTags.Blocks.RUBY_LASER_NO_SIGNAL);
            if (!blocks && state.m_204336_(RNTags.Blocks.RUBY_LASER_TRANSPARENT) || (shape = Shapes.m_83113_((VoxelShape)state.m_60812_((BlockGetter)this.f_58857_, (BlockPos)mutableBlockPos), (VoxelShape)BEAM_SEGMENT_SHAPES.get(facing), (BooleanOp)BooleanOp.f_82689_)).m_83281_()) continue;
            if (this.f_58857_.f_46443_) {
                Direction.Axis axis = facing.m_122434_();
                double d = this.rangeRemnant = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? shape.m_83288_(axis) : 1.0 - shape.m_83297_(axis);
            }
            if (!blocks) break;
            this.currentLaserRange = this.blockRange;
            break;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_121945_(facing));
        this.silly = state.m_204336_(RNTags.Blocks.RUBY_GLASS);
        boolean bl = this.visible = this.silly || state.m_204336_(Platform.getGlassTag());
        if (this.visible && !this.silly && state.m_60734_() instanceof BeaconBeamBlock) {
            DyeColor dye = ((BeaconBeamBlock)state.m_60734_()).m_7988_();
            this.color = dye.m_41068_();
        } else {
            this.color = null;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)RubyLaserBlock.TINTED)).booleanValue()) {
            this.powerLevel = Mth.m_14045_((int)(this.currentLaserRange - this.blockRange), (int)0, (int)15);
            if (this.powerLevel != (Integer)this.m_58900_().m_61143_((Property)RubyLaserBlock.POWER)) {
                this.f_58857_.m_186460_(this.m_58899_(), (Block)RNBlocks.RUBY_LASER.get(), 2);
            }
        }
    }

    @Override
    public boolean shouldRemove() {
        return this.m_58901_();
    }

    @Override
    public Stream<BlockPos> getListenedPositions() {
        Vec3i offset = ((Direction)this.m_58900_().m_61143_((Property)RubyLaserBlock.f_52588_)).m_122436_().m_142393_(15);
        return BlockPos.m_121990_((BlockPos)this.f_58858_, (BlockPos)this.f_58858_.m_121955_(offset));
    }

    public AABB getRenderBoundingBox() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)RubyLaserBlock.f_52588_);
        Vec3i end = facing.m_122436_().m_142393_(this.currentLaserRange + 1);
        return new AABB(this.f_58858_).m_82363_((double)end.m_123341_(), (double)end.m_123342_(), (double)end.m_123343_());
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public int getBlockRange() {
        return this.blockRange == -1 ? this.currentLaserRange : Mth.m_14045_((int)this.blockRange, (int)0, (int)this.currentLaserRange);
    }

    public double getRenderRange() {
        return (double)this.getBlockRange() + this.rangeRemnant;
    }

    public boolean alwaysVisible() {
        return this.visible;
    }

    public boolean isColored() {
        return this.color != null;
    }

    public boolean isSilly() {
        return this.silly;
    }

    public float[] getColor() {
        return this.color;
    }
}

