/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.content.block.freezer;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.stream.Stream;
import net.artienia.rubinated_nether.content.RNRecipes;
import net.artienia.rubinated_nether.content.block.freezer.AbstractFreezerBlockEntity;
import net.artienia.rubinated_nether.content.recipe.freezing.FreezingRecipe;
import net.artienia.rubinated_nether.content.screen.FreezerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FreezerBlockEntity
extends AbstractFreezerBlockEntity {
    private static final Object2IntMap<Item> freezingMap = new Object2IntLinkedOpenHashMap();
    private static final Object2IntMap<TagKey<Item>> tagFreezingMap = new Object2IntLinkedOpenHashMap();

    public FreezerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, (RecipeType<? extends FreezingRecipe>)((RecipeType)RNRecipes.FREEZING.get()));
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"menu.rubinated_nether.freezer");
    }

    public AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new FreezerMenu(id, playerInventory, (Container)this, this.f_58311_);
    }

    public int m_7743_(ItemStack fuelStack) {
        if (fuelStack.m_41619_() || !FreezerBlockEntity.getFreezingMap().containsKey((Object)fuelStack.m_41720_())) {
            return 0;
        }
        return FreezerBlockEntity.getFreezingMap().getInt((Object)fuelStack.m_41720_());
    }

    public static Object2IntMap<Item> getFreezingMap() {
        if (tagFreezingMap.isEmpty()) {
            return Object2IntMaps.unmodifiable(freezingMap);
        }
        Object2IntOpenHashMap allItems = new Object2IntOpenHashMap(freezingMap);
        tagFreezingMap.object2IntEntrySet().stream().flatMap(entry -> FreezerBlockEntity.streamTagFuels((TagKey<Item>)((TagKey)entry.getKey()), entry.getIntValue())).forEach(arg_0 -> FreezerBlockEntity.lambda$getFreezingMap$1((Object2IntMap)allItems, arg_0));
        return Object2IntMaps.unmodifiable((Object2IntMap)allItems);
    }

    private static Stream<ObjectIntPair<Item>> streamTagFuels(TagKey<Item> tag, int freezeTime) {
        return BuiltInRegistries.f_257033_.m_203431_(tag).map(set -> set.m_203614_().map(h -> ObjectIntPair.of((Object)((Item)h.m_203334_()), (int)freezeTime))).orElseGet(Stream::empty);
    }

    public static void addItemFreezingTime(ItemLike itemProvider, int burnTime) {
        Item item = itemProvider.m_5456_();
        freezingMap.put((Object)item, burnTime);
    }

    public static void addItemsFreezingTime(ItemLike[] itemProviders, int burnTime) {
        Stream.of(itemProviders).map(ItemLike::m_5456_).forEach(item -> freezingMap.put(item, burnTime));
    }

    public static void addItemTagFreezingTime(TagKey<Item> itemTag, int burnTime) {
        tagFreezingMap.put(itemTag, burnTime);
    }

    public static void removeItemFreezingTime(ItemLike itemProvider) {
        Item item = itemProvider.m_5456_();
        freezingMap.removeInt((Object)item);
    }

    public static void removeItemsFreezingTime(ItemLike[] itemProviders) {
        Stream.of(itemProviders).map(ItemLike::m_5456_).forEach(arg_0 -> freezingMap.removeInt(arg_0));
    }

    public static void removeItemTagFreezingTime(TagKey<Item> itemTag) {
        tagFreezingMap.removeInt(itemTag);
    }

    private static /* synthetic */ void lambda$getFreezingMap$1(Object2IntMap allItems, ObjectIntPair pair) {
        allItems.put((Object)((Item)pair.key()), pair.valueInt());
    }
}

