/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.content.block;

import java.util.List;
import net.artienia.rubinated_nether.content.RNBlockEntities;
import net.artienia.rubinated_nether.content.RNBlocks;
import net.artienia.rubinated_nether.content.RNParticleTypes;
import net.artienia.rubinated_nether.content.block.RubinationAltarBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import uwu.serenity.critter.utils.BEBlock;

public class RubinationAltarBlock
extends BaseEntityBlock
implements BEBlock<RubinationAltarBlockEntity> {
    protected static final VoxelShape SHAPE_BOTTOM = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    protected static final VoxelShape SHAPE_TOP = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)SHAPE_BOTTOM, (VoxelShape)SHAPE_TOP);
    public static final List<BlockPos> RUNESTONE_OFFSETS = BlockPos.m_121886_((int)-3, (int)0, (int)-3, (int)3, (int)1, (int)3).filter(blockPos -> Math.abs(blockPos.m_123341_()) > 1 || Math.abs(blockPos.m_123343_()) > 1).map(BlockPos::m_7949_).toList();

    public RubinationAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean isValidBookShelf(Level level, BlockPos tablePos, BlockPos offsetPos) {
        return level.m_8055_(tablePos.m_121955_((Vec3i)offsetPos)).m_60713_((Block)RNBlocks.RUNESTONE.get()) && level.m_8055_(tablePos.m_7918_(offsetPos.m_123341_() / 2, offsetPos.m_123342_(), offsetPos.m_123343_() / 2)).m_204336_(BlockTags.f_278486_);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.rubinated_nether.wip.tooltip"));
        super.m_5871_(stack, level, tooltip, flag);
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        for (BlockPos blockPos : RUNESTONE_OFFSETS) {
            if (random.m_188503_(1) != 0 || !RubinationAltarBlock.isValidBookShelf(level, pos, blockPos)) continue;
            level.m_7106_((ParticleOptions)RNParticleTypes.RUBINATE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5, (double)((float)blockPos.m_123341_() + random.m_188501_()) - 0.5, (double)((float)blockPos.m_123342_() - random.m_188501_() - 0.5f), (double)((float)blockPos.m_123343_() + random.m_188501_()) - 0.5);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnchantmentTableBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? RubinationAltarBlock.m_152132_(blockEntityType, (BlockEntityType)BlockEntityType.f_58928_, EnchantmentTableBlockEntity::m_155503_) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(state.m_60750_(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        Component component = ((Nameable)blockEntity).m_5446_();
        return new SimpleMenuProvider((i, inventory, player) -> new EnchantmentMenu(i, inventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos)), component);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockEntityType<? extends RubinationAltarBlockEntity> getBlockEntityType() {
        return (BlockEntityType)RNBlockEntities.RUBINATION_ALTAR.get();
    }

    public Class<? extends RubinationAltarBlockEntity> getBlockEntityClass() {
        return RubinationAltarBlockEntity.class;
    }
}

