/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.content.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class LavaSpongeBlock
extends Block {
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;
    private static final Direction[] ALL_DIRECTIONS = Direction.values();

    public LavaSpongeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.tryAbsorbLava(level, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        this.tryAbsorbLava(level, pos);
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    protected void tryAbsorbLava(Level level, BlockPos pos) {
        if (this.removeLavaBreadthFirstSearch(level, pos)) {
            level.m_7731_(pos, Blocks.f_50450_.m_49966_(), 2);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_49991_.m_49966_()));
        }
    }

    private boolean removeLavaBreadthFirstSearch(Level level, BlockPos pos) {
        return BlockPos.m_276833_((BlockPos)pos, (int)6, (int)65, (blockPos, consumer) -> {
            for (Direction direction : ALL_DIRECTIONS) {
                consumer.accept(blockPos.m_121945_(direction));
            }
        }, blockPos2 -> {
            BucketPickup bucketPickup;
            if (blockPos2.equals((Object)pos)) {
                return true;
            }
            BlockState blockState = level.m_8055_(blockPos2);
            FluidState fluidState = level.m_6425_(blockPos2);
            if (!fluidState.m_205070_(FluidTags.f_13132_)) {
                return false;
            }
            Block block = blockState.m_60734_();
            if (block instanceof BucketPickup && !(bucketPickup = (BucketPickup)block).m_142598_((LevelAccessor)level, blockPos2, blockState).m_41619_()) {
                return true;
            }
            if (blockState.m_60734_() instanceof LiquidBlock) {
                level.m_7731_(blockPos2, Blocks.f_50016_.m_49966_(), 3);
            } else {
                if (!(blockState.m_60713_(Blocks.f_50575_) || blockState.m_60713_(Blocks.f_50576_) || blockState.m_60713_(Blocks.f_50037_) || blockState.m_60713_(Blocks.f_50038_))) {
                    return false;
                }
                BlockEntity blockEntity = blockState.m_155947_() ? level.m_7702_(blockPos2) : null;
                LavaSpongeBlock.m_49892_((BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos2, (BlockEntity)blockEntity);
                level.m_7731_(blockPos2, Blocks.f_50016_.m_49966_(), 3);
            }
            return true;
        }) > 1;
    }
}

