/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.client.render.blockEntity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.artienia.rubinated_nether.RubinatedNether;
import net.artienia.rubinated_nether.client.render.RNRenderTypes;
import net.artienia.rubinated_nether.client.render.ShaderHelper;
import net.artienia.rubinated_nether.content.block.ruby_laser.RubyLaserBlock;
import net.artienia.rubinated_nether.content.block.ruby_laser.RubyLaserBlockEntity;
import net.artienia.rubinated_nether.platform.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class RubyLaserRenderer
implements BlockEntityRenderer<RubyLaserBlockEntity> {
    public static final ResourceLocation LASER_TEXTURE = RubinatedNether.id("textures/misc/ruby_laser_beam.png");
    public static final ResourceLocation LASER_TEXTURE_GREYSCALE = RubinatedNether.id("textures/misc/ruby_laser_beam_greyscale.png");
    private static final float[] BASE_COLOR = new float[]{1.0f, 1.0f, 1.0f};
    private static final float[] TINTED_COLOR = new float[]{1.0f, 0.0f, 0.5f};
    private final Quaternionf tempQuat = new Quaternionf();

    public RubyLaserRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RubyLaserBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (blockEntity.alwaysVisible() || Platform.rubyLensEquipped((Player)player)) {
            float[] color;
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)RubyLaserBlock.f_52588_);
            float xRot = facing == Direction.UP ? 0.0f : (Direction.Plane.VERTICAL.test(facing) ? 180.0f : 90.0f);
            float zRot = (float)(Math.max(facing.m_122416_(), 0) & 3) * 90.0f;
            this.tempQuat.rotationXYZ(xRot * ((float)Math.PI / 180), 0.0f, zRot * ((float)Math.PI / 180));
            float lerpedTime = Mth.m_14179_((float)partialTick, (float)level.m_46467_(), (float)(level.m_46467_() + 1L));
            float angle = lerpedTime * 3.0f % 360.0f;
            this.tempQuat.rotateY(angle * ((float)Math.PI / 180));
            poseStack.m_252781_(this.tempQuat);
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            float maxY = (float)(blockEntity.getRenderRange() + 1.0);
            if (blockEntity.isColored()) {
                color = blockEntity.getColor();
            } else if (blockEntity.isSilly()) {
                float hue = lerpedTime % 50.0f / 50.0f;
                int col = Mth.m_14169_((float)hue, (float)0.8f, (float)1.0f);
                color = new float[]{FastColor.ARGB32.m_13665_((int)col), FastColor.ARGB32.m_13667_((int)col), FastColor.ARGB32.m_13669_((int)col)};
            } else {
                color = (Boolean)blockEntity.m_58900_().m_61143_((Property)RubyLaserBlock.TINTED) != false ? TINTED_COLOR : BASE_COLOR;
            }
            VertexConsumer consumer = buffer.m_6299_(this.getRenderType(blockEntity.isColored() || blockEntity.isSilly()));
            this.renderFace(poseStack, consumer, 0.4f, 1.0f, 0.6f, 0.6f, maxY, 0.6f, color, lerpedTime, Direction.NORTH);
            this.renderFace(poseStack, consumer, 0.6f, 1.0f, 0.4f, 0.4f, maxY, 0.4f, color, lerpedTime, Direction.SOUTH);
            this.renderFace(poseStack, consumer, 0.4f, 1.0f, 0.4f, 0.4f, maxY, 0.6f, color, lerpedTime, Direction.EAST);
            this.renderFace(poseStack, consumer, 0.6f, 1.0f, 0.6f, 0.6f, maxY, 0.4f, color, lerpedTime, Direction.WEST);
            poseStack.m_85849_();
        }
    }

    private void renderFace(PoseStack matrices, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float[] color, float ticks, Direction face) {
        PoseStack.Pose pose = matrices.m_85850_();
        float maxV = (maxY - 1.0f) / 15.0f;
        float endAlpha = Mth.m_14036_((float)(1.0f - maxV), (float)0.0f, (float)1.0f);
        float v0 = 1.0f - ticks % 150.0f / 150.0f;
        float v1 = v0 + maxV * 0.4f;
        float r = color[0];
        float g = color[1];
        float b = color[2];
        buffer.m_252986_(pose.m_252922_(), minX, minY, minZ).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), (float)face.m_122429_(), (float)face.m_122430_(), (float)face.m_122431_()).m_5752_();
        buffer.m_252986_(pose.m_252922_(), maxX, minY, maxZ).m_85950_(r, g, b, 1.0f).m_7421_(1.0f, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), (float)face.m_122429_(), (float)face.m_122430_(), (float)face.m_122431_()).m_5752_();
        buffer.m_252986_(pose.m_252922_(), maxX, maxY, maxZ).m_85950_(r, g, b, endAlpha).m_7421_(1.0f, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), (float)face.m_122429_(), (float)face.m_122430_(), (float)face.m_122431_()).m_5752_();
        buffer.m_252986_(pose.m_252922_(), minX, maxY, minZ).m_85950_(r, g, b, endAlpha).m_7421_(0.0f, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pose.m_252943_(), (float)face.m_122429_(), (float)face.m_122430_(), (float)face.m_122431_()).m_5752_();
    }

    protected RenderType getRenderType(boolean colored) {
        if (ShaderHelper.isShaderPackInUse()) {
            return RenderType.m_234338_((ResourceLocation)(colored ? LASER_TEXTURE_GREYSCALE : LASER_TEXTURE));
        }
        return colored ? RNRenderTypes.LASER_BEAM_GREYSCALE : RNRenderTypes.LASER_BEAM;
    }
}

