/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.client;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.artienia.rubinated_nether.client.particles.RubinationAltarParticle;
import net.artienia.rubinated_nether.client.particles.RubyAuraParticle;
import net.artienia.rubinated_nether.client.render.entity.RubyLensModel;
import net.artienia.rubinated_nether.client.render.entity.RubyLensRenderLayer;
import net.artienia.rubinated_nether.content.RNParticleTypes;
import net.artienia.rubinated_nether.integrations.RNModCompat;
import net.artienia.rubinated_nether.utils.ParticleFactoryConsumer;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RubinatedNetherClient {
    public static void clientSetup() {
        RNModCompat.clientSetup();
    }

    public static void registeModelLayes(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> layers) {
        layers.accept(RubyLensModel.LAYER_LOCATION, RubyLensModel::createBodyLayer);
    }

    public static void registerEntityLayers(EntityRenderDispatcher dispatcher, EntityModelSet models, Function<String, PlayerRenderer> skinGetter) {
        dispatcher.f_114362_.forEach((type, renderer) -> {
            LivingEntityRenderer livingRenderer;
            if (renderer instanceof LivingEntityRenderer && (livingRenderer = (LivingEntityRenderer)renderer).m_7200_() instanceof HeadedModel) {
                livingRenderer.m_115326_(new RubyLensRenderLayer(livingRenderer, models, livingRenderer.m_7200_()));
            }
        });
        PlayerRenderer defaultSkin = skinGetter.apply("default");
        PlayerRenderer slimSkin = skinGetter.apply("slim");
        defaultSkin.m_115326_(new RubyLensRenderLayer(defaultSkin, models, (PlayerModel)defaultSkin.m_7200_()));
        slimSkin.m_115326_(new RubyLensRenderLayer(slimSkin, models, (PlayerModel)slimSkin.m_7200_()));
    }

    public static void registerParticleFactories(ParticleFactoryConsumer registrar) {
        registrar.register((ParticleType)RNParticleTypes.RUBY_AURA.get(), RubyAuraParticle.Provider::new);
        registrar.register((ParticleType)RNParticleTypes.RUBINATE.get(), RubinationAltarParticle.Provider::new);
    }
}

