/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.world.caravans;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.caravans.registry.CaravanRegistries;
import dev.obscuria.caravans.world.caravans.CaravanMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record CaravanVariation(int cooldown, CaravanMember leader, @Unmodifiable List<CaravanMember> members) {
    public static final Codec<Holder<CaravanVariation>> CODEC = RegistryFixedCodec.m_206740_(CaravanRegistries.Keys.VARIATION);
    public static final Codec<CaravanVariation> DIRECT_CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("cooldown").forGetter(CaravanVariation::cooldown), (App)CaravanMember.CODEC.fieldOf("leader").forGetter(CaravanVariation::leader), (App)CaravanMember.CODEC.listOf().fieldOf("members").forGetter(CaravanVariation::members)).apply((Applicative)codec, CaravanVariation::new));

    public int spawn(ServerLevel level, BlockPos position) {
        RandomSource random = level.f_46441_;
        BlockPos.MutableBlockPos pos = position.m_122032_();
        pos.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)pos).m_123342_());
        if (this.leader.spawn(level, (BlockPos)pos, true) == null) {
            return 0;
        }
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (CaravanMember member : this.members) {
            for (int i = 0; i < member.count(); ++i) {
                pos.m_142451_(pos.m_123341_() + random.m_188503_(3) - random.m_188503_(3));
                pos.m_142443_(pos.m_123343_() + random.m_188503_(3) - random.m_188503_(3));
                pos.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)pos).m_123342_());
                Entity entity = member.spawn(level, (BlockPos)pos, false);
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        this.leashAnimals(entities, random);
        return 1 + entities.size();
    }

    private void leashAnimals(List<Entity> entities, RandomSource random) {
        @Nullable Animal lastAnimal = null;
        ArrayList holders = entities.stream().filter(this::isValidLeashHolder).collect(Collectors.toCollection(ArrayList::new));
        for (Entity member : entities) {
            if (!(member instanceof Animal)) continue;
            Animal animal = (Animal)member;
            if (lastAnimal != null && random.m_188503_(4) < 3) {
                animal.m_21463_(lastAnimal, true);
            } else {
                Entity holder;
                Collections.shuffle(holders);
                Entity entity = holder = holders.isEmpty() ? null : (Entity)holders.get(0);
                if (holder != null) {
                    animal.m_21463_(holder, true);
                }
            }
            lastAnimal = animal;
        }
    }

    private boolean isValidLeashHolder(Entity entity) {
        return entity instanceof AbstractIllager;
    }
}

