/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.caravans.world.caravans;

import dev.obscuria.caravans.PillagerCaravans;
import dev.obscuria.caravans.registry.CaravanRegistries;
import dev.obscuria.caravans.world.IWeighted;
import dev.obscuria.caravans.world.caravans.CaravanPlacement;
import dev.obscuria.caravans.world.caravans.CaravanVariation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public final class CaravanSpawner
implements CustomSpawner {
    private static final int ATTEMPT_INTERVAL = 1200;
    private static final int DISTANCE = 32;
    private static final int SPREAD = 32;
    private int cooldownTick = 12000;

    public int m_7995_(ServerLevel level, boolean spawnHostile, boolean spawnFriendly) {
        if (!this.shouldSpawn(level, spawnHostile)) {
            return 0;
        }
        ServerPlayer player = this.selectPlayer(level);
        if (player == null) {
            return 0;
        }
        BlockPos.MutableBlockPos pos = this.selectPosition(level, player);
        if (pos == null) {
            return 0;
        }
        Holder<CaravanVariation> caravan = this.selectCaravan(level, (BlockPos)pos);
        if (caravan == null) {
            return 0;
        }
        int totalSpawned = ((CaravanVariation)caravan.m_203334_()).spawn(level, (BlockPos)pos);
        if (totalSpawned <= 0) {
            return 0;
        }
        this.cooldownTick = ((CaravanVariation)caravan.m_203334_()).cooldown();
        return totalSpawned;
    }

    private boolean shouldSpawn(ServerLevel level, boolean spawnHostile) {
        if (!spawnHostile || !level.m_46469_().m_46207_(PillagerCaravans.RULE_DO_CARAVAN_SPAWNING)) {
            return false;
        }
        if (--this.cooldownTick > 0) {
            return false;
        }
        this.cooldownTick = 1200;
        return level.m_46468_() / 24000L >= 1L;
    }

    @Nullable
    private ServerPlayer selectPlayer(ServerLevel level) {
        int players = level.m_6907_().size();
        if (players < 1) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)level.m_6907_().get(level.f_46441_.m_188503_(players));
        if (player.m_5833_()) {
            return null;
        }
        if (level.m_8736_(player.m_20183_(), 2)) {
            return null;
        }
        return player;
    }

    @Nullable
    private BlockPos.MutableBlockPos selectPosition(ServerLevel level, ServerPlayer player) {
        RandomSource random = level.f_46441_;
        int xOffset = (32 + random.m_188503_(32)) * (random.m_188499_() ? -1 : 1);
        int yOffset = (32 + random.m_188503_(32)) * (random.m_188499_() ? -1 : 1);
        BlockPos.MutableBlockPos pos = player.m_20183_().m_122032_().m_122184_(xOffset, 0, yOffset);
        if (!level.m_151572_(pos.m_123341_() - 10, pos.m_123343_() - 10, pos.m_123341_() + 10, pos.m_123343_() + 10)) {
            return null;
        }
        return pos;
    }

    @Nullable
    private Holder<CaravanVariation> selectCaravan(ServerLevel level, BlockPos pos) {
        Registry registry = level.m_9598_().m_175515_(CaravanRegistries.Keys.PLACEMENT);
        Holder biome = level.m_204166_(pos);
        List<CaravanPlacement> candidates = registry.m_123024_().filter(it -> it.isFor((Holder<Biome>)biome)).toList();
        CaravanPlacement placement = IWeighted.pickRandom(candidates, level.f_46441_);
        return placement == null ? null : placement.getRandomVariation(level.f_46441_);
    }
}

