/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.util.json.data;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BowParticleData {
    private final String type;
    private final Vec3 posOffset;
    private final Vec3 velocity;
    private final int count;
    private final float lookOffset;

    public BowParticleData(String type, Vec3 offset, Vec3 velocity, int count, float lookOffset) {
        this.type = type;
        this.posOffset = offset;
        this.velocity = velocity;
        this.count = count;
        this.lookOffset = lookOffset;
    }

    @Nullable
    public SimpleParticleType getType() {
        return (SimpleParticleType)BuiltInRegistries.f_257034_.m_7745_(new ResourceLocation(this.type));
    }

    public Vec3 getPosOffset() {
        return this.posOffset;
    }

    public Vec3 getVelocity() {
        return this.velocity;
    }

    public int getCount() {
        return this.count;
    }

    public float getLookOffset() {
        return this.lookOffset;
    }

    public void apply(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getType() != null) {
                Vec3 offset = this.getPosOffset();
                Vec3 velocity = this.getVelocity();
                Vec3 lookVector = entity.m_20154_();
                Vec3 inFrontPos = entity.m_20182_().m_82549_(lookVector.m_82490_((double)this.getLookOffset()));
                serverLevel.m_8767_((ParticleOptions)this.getType(), inFrontPos.f_82479_ + offset.f_82479_, entity.m_20188_() + offset.f_82480_, inFrontPos.m_7094_() + offset.f_82481_, this.getCount(), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_, 0.0);
            }
        }
    }

    public static BowParticleData fromJson(JsonObject json) {
        String effect = json.has("effect") ? json.get("effect").getAsString() : "minecraft:empty";
        float x = json.has("xoffset") ? json.get("xoffset").getAsFloat() : 0.0f;
        float y = json.has("yoffset") ? json.get("yoffset").getAsFloat() : 0.0f;
        float z = json.has("zoffset") ? json.get("zoffset").getAsFloat() : 0.0f;
        float vx = json.has("xvel") ? json.get("xvel").getAsFloat() : 0.0f;
        float vy = json.has("yvel") ? json.get("yvel").getAsFloat() : 0.0f;
        float vz = json.has("zvel") ? json.get("zvel").getAsFloat() : 0.0f;
        int count = json.has("count") ? json.get("count").getAsInt() : 0;
        float lookOffset = json.has("look_offset") ? json.get("look_offset").getAsFloat() : 0.0f;
        return new BowParticleData(effect, new Vec3((double)x, (double)y, (double)z), new Vec3((double)vx, (double)vy, (double)vz), count, lookOffset);
    }
}

