/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.util;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.infernalstudios.archeryexp.util.json.data.BowEffectData;
import org.infernalstudios.archeryexp.util.mixinterfaces.IBowProperties;
import org.jetbrains.annotations.NotNull;

public class BowTooltipUtil {
    public static void addBowTooltips(List<Component> toolips, @NotNull ItemStack itemStack) {
        IBowProperties bow;
        Item item = itemStack.m_41720_();
        if (item instanceof IBowProperties && (bow = (IBowProperties)item).archeryexp$isSpecial() && bow.archeryexp$hasDesc()) {
            boolean debug = Minecraft.m_91087_().f_91066_.f_92125_;
            int i = Math.max(0, toolips.size() - (debug ? (itemStack.m_41782_() ? 2 : 1) : 0));
            toolips.add(i++, CommonComponents.f_237098_);
            toolips.add(i++, (Component)Component.m_237115_((String)"attribute.archeryexp.mainhand").m_130940_(ChatFormatting.GRAY));
            toolips.add(i++, BowTooltipUtil.addAttributePos("base_damage", Float.valueOf(bow.archeryexp$getBaseDamage())));
            toolips.add(i++, BowTooltipUtil.addAttributePos("draw_cooldown", bow.archeryexp$getBowCooldown()));
            toolips.add(i++, BowTooltipUtil.addAttributePos("charge_time", bow.archeryexp$getChargeTime()));
            float speed = bow.archeryexp$getWalkSpeed();
            if (speed < 1.0f) {
                toolips.add(i++, BowTooltipUtil.addAttributeNeg("walk_speed_down", BowTooltipUtil.round((speed - 1.0f) * -100.0f) + "%"));
            } else if (speed > 1.0f) {
                toolips.add(i++, BowTooltipUtil.addAttributePos("walk_speed_up", BowTooltipUtil.round((speed - 1.0f) * 100.0f) + "%"));
            }
            float recoil = bow.archeryexp$getRecoil();
            if (recoil > 0.0f) {
                toolips.add(i++, BowTooltipUtil.addAttributeNeg("recoil", BowTooltipUtil.round(bow.archeryexp$getRecoil() * 100.0f) + "%"));
            }
            toolips.add(i++, CommonComponents.f_237098_);
            BowTooltipUtil.appendStatusEffectTooltips(bow, toolips, i);
        }
    }

    private static float round(float f) {
        return (float)Math.round(f * 100.0f) / 100.0f;
    }

    private static Component addAttributePos(String type, Object ... args) {
        return CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)("attribute.archeryexp." + type), (Object[])args)).m_130940_(ChatFormatting.DARK_GREEN);
    }

    private static Component addAttributeNeg(String type, Object ... args) {
        return CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)("attribute.archeryexp." + type), (Object[])args)).m_130940_(ChatFormatting.RED);
    }

    private static void appendStatusEffectTooltips(IBowProperties bow, List<Component> toolips, int i) {
        for (BowEffectData effect : bow.archeryexp$getEffects()) {
            MobEffect status = effect.getEffect();
            if (status == null && (status = effect.getFallbackEffect()) == null || !effect.hasTooltip()) continue;
            MobEffectInstance mobEffectInstance = new MobEffectInstance(status, effect.getLength(), effect.getLevel());
            MutableComponent effectText = Component.m_237115_((String)mobEffectInstance.m_19576_());
            effectText = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectText, Component.m_237115_((String)("potion.potency." + mobEffectInstance.m_19564_()))});
            effectText = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{effectText, MobEffectUtil.m_267641_((MobEffectInstance)mobEffectInstance, (float)1.0f)});
            toolips.add(i++, (Component)effectText.m_130940_(status.m_19486_() ? ChatFormatting.BLUE : ChatFormatting.RED));
        }
    }
}

