/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.mixin.entity;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import org.infernalstudios.archeryexp.ArcheryExpansion;
import org.infernalstudios.archeryexp.common.misc.ArcheryTags;
import org.infernalstudios.archeryexp.platform.Services;
import org.infernalstudios.archeryexp.util.mixinterfaces.IBowProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void archeryexp$tick(CallbackInfo ci) {
        Item item;
        Player user = (Player)this;
        ItemStack bowStack = user.m_21211_();
        AttributeInstance speedAttribute = user.m_21051_(Attributes.f_22279_);
        if (user.m_6117_() && (item = bowStack.m_41720_()) instanceof IBowProperties) {
            IBowProperties bow = (IBowProperties)item;
            if (speedAttribute != null && bow.archeryexp$isSpecial() && speedAttribute.m_22111_(ArcheryExpansion.BOW_DRAW_SPEED_MODIFIER_ID) == null) {
                AttributeModifier speedModifier = new AttributeModifier(ArcheryExpansion.BOW_DRAW_SPEED_MODIFIER_ID, "Bow Speed Boost", (double)(bow.archeryexp$getWalkSpeed() - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL);
                speedAttribute.m_22118_(speedModifier);
            }
        } else if (speedAttribute != null && speedAttribute.m_22111_(ArcheryExpansion.BOW_DRAW_SPEED_MODIFIER_ID) != null) {
            speedAttribute.m_22120_(ArcheryExpansion.BOW_DRAW_SPEED_MODIFIER_ID);
        }
        if (!user.m_9236_().m_5776_() && !ArcheryExpansion.BOW_STAT_PLAYER_LIST.contains((ServerPlayer)user)) {
            for (Item item2 : BuiltInRegistries.f_257033_) {
                BowItem bowItem;
                IBowProperties bow;
                if (!(item2 instanceof BowItem) || !(bow = (IBowProperties)(bowItem = (BowItem)item2)).archeryexp$isSpecial()) continue;
                Services.PLATFORM.sendBowStatsPacket((ServerPlayer)user, bowItem.m_7968_(), bow.archeryexp$getRange(), bow.archeryexp$getChargeTime(), bow.archeryexp$getWalkSpeed(), bow.archeryexp$getOffsetX(), bow.archeryexp$getOffsetY());
            }
            ArcheryExpansion.BOW_STAT_PLAYER_LIST.add((ServerPlayer)user);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    private void archeryexp$attack(Entity target, CallbackInfo ci) {
        Player user = (Player)this;
        if (this.archeryexp$isCritting(target) && user.m_21205_().m_204117_(ArcheryTags.CAN_BREAK_BOW) && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_6167_().forEach(stack -> {
                Item patt4382$temp = stack.m_41720_();
                if (patt4382$temp instanceof IBowProperties) {
                    IBowProperties bow = (IBowProperties)patt4382$temp;
                    if ((float)living.m_217043_().m_188503_(100) < bow.archeryexp$getBreakChance() * 100.0f) {
                        int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
                        float breakResistance = (float)level * 0.1f + bow.archeryexp$getBreakResist();
                        int damage = this.archeryexp$getDurabilityLeft((ItemStack)stack) - Math.round((float)this.archeryexp$getDurabilityLeft((ItemStack)stack) * breakResistance);
                        stack.m_41622_(damage, living, entity -> {
                            entity.m_21190_(entity.m_7655_());
                            entity.m_21008_(entity.m_7655_(), new ItemStack((ItemLike)Items.f_41852_));
                        });
                    }
                }
            });
        }
    }

    @Unique
    private boolean archeryexp$isCritting(Entity target) {
        Player user = (Player)this;
        float $$4 = user.m_36403_(0.5f);
        boolean $$5 = $$4 > 0.9f;
        boolean $$8 = $$5 && user.f_19789_ > 0.0f && !user.m_20096_() && !user.m_6147_() && !user.m_20069_() && !user.m_21023_(MobEffects.f_19610_) && !user.m_20159_() && target instanceof LivingEntity;
        $$8 = $$8 && !user.m_20142_();
        return $$8;
    }

    @Unique
    public int archeryexp$getDurabilityLeft(ItemStack item) {
        return item.m_41776_() - (item.m_41783_() == null ? 0 : item.m_41783_().m_128451_("Damage"));
    }
}

