/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.infernalstudios.archeryexp.client.MockItemRenderer;
import org.infernalstudios.archeryexp.util.ArrowPullUtil;
import org.infernalstudios.archeryexp.util.BowUtil;
import org.infernalstudios.archeryexp.util.mixinterfaces.IBowProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;renderModelLists(Lnet/minecraft/client/resources/model/BakedModel;Lnet/minecraft/world/item/ItemStack;IILcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V", shift=At.Shift.AFTER)})
    public void archeryexp$render(ItemStack stack, ItemDisplayContext context, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, int light, int $$6, BakedModel model, CallbackInfo ci) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (Entity entity : level.m_104735_()) {
                ItemStack arrow;
                IBowProperties bow;
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity user = (LivingEntity)entity;
                Item item = stack.m_41720_();
                if (!(item instanceof IBowProperties) || !this.archeryexp$usingValid(bow = (IBowProperties)item, user, stack) || (arrow = user.m_6298_(stack)).m_41619_()) continue;
                float pull = BowUtil.getPowerForDrawTime(stack.m_41779_() - user.m_21212_(), bow);
                float offset = pull >= 0.9f ? 0.125f : (pull >= 0.65f ? 0.0625f : 0.0f);
                poseStack.m_85836_();
                poseStack.m_85841_(1.01f, 1.01f, 1.01f);
                poseStack.m_252880_(0.995f + offset - 0.125f * -bow.archeryexp$getOffsetX(), 0.995f - offset - 0.125f * bow.archeryexp$getOffsetY(), 0.495f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                if (arrow.m_150930_(Items.f_42738_)) {
                    MockItemRenderer.renderTintedItem(poseStack, bufferSource, light, ArrowPullUtil.TIPPED_TIP, PotionUtils.m_43575_((ItemStack)arrow));
                    MockItemRenderer.renderItem(poseStack, bufferSource, light, ArrowPullUtil.TIPPED_SHAFT);
                } else {
                    MockItemRenderer.renderItem(poseStack, bufferSource, light, ArrowPullUtil.getPullingTexture(arrow));
                }
                poseStack.m_85849_();
            }
        }
    }

    @Unique
    public boolean archeryexp$usingValid(IBowProperties bow, LivingEntity user, ItemStack stack) {
        return bow.archeryexp$isSpecial() && user.m_6117_() && user.m_21211_() == stack;
    }
}

