/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.common.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.infernalstudios.archeryexp.ArcheryExpansion;
import org.infernalstudios.archeryexp.common.items.ArcheryExpansionBow;
import org.infernalstudios.archeryexp.common.items.arrows.DiamondArrowItem;
import org.infernalstudios.archeryexp.common.items.arrows.GoldArrowItem;
import org.infernalstudios.archeryexp.common.items.arrows.IronArrowItem;
import org.infernalstudios.archeryexp.common.items.arrows.NetheriteArrowItem;
import org.infernalstudios.archeryexp.platform.Services;

public class ArcheryItems {
    public static final List<Supplier<Item>> WEAPONS = new ArrayList<Supplier<Item>>();
    public static final List<Supplier<Item>> BOWS = new ArrayList<Supplier<Item>>();
    public static final Supplier<Item> GOLD_BOW = ArcheryItems.registerBow("gold", 80, Items.f_42417_);
    public static final Supplier<Item> IRON_BOW = ArcheryItems.registerBow("iron", 240, Items.f_42416_);
    public static final Supplier<Item> DIAMOND_BOW = ArcheryItems.registerBow("diamond", 528, Items.f_42415_);
    public static final Supplier<Item> NETHERITE_BOW = ArcheryItems.registerBow("netherite", 592, Items.f_42418_);
    public static final Supplier<Item> WOODEN_BOW = ArcheryItems.registerBow("wooden", 112, Items.f_42398_);
    public static Supplier<Item> GOLD_ARROW = ArcheryItems.registerItem("gold_arrow", () -> new GoldArrowItem(new Item.Properties()));
    public static Supplier<Item> IRON_ARROW = ArcheryItems.registerItem("iron_arrow", () -> new IronArrowItem(new Item.Properties()));
    public static Supplier<Item> DIAMOND_ARROW = ArcheryItems.registerItem("diamond_arrow", () -> new DiamondArrowItem(new Item.Properties()));
    public static Supplier<Item> NETHERITE_ARROW = ArcheryItems.registerItem("netherite_arrow", () -> new NetheriteArrowItem(new Item.Properties().m_41486_()));

    private static Supplier<Item> registerBow(String type, int durability, Item repairMaterial) {
        Supplier<Item> regItem = ArcheryItems.registerItem(type + "_bow", () -> new ArcheryExpansionBow(new Item.Properties().m_41487_(1).m_41503_(durability), repairMaterial));
        BOWS.add(regItem);
        return regItem;
    }

    private static Supplier<Item> registerItem(String name, Supplier<Item> item) {
        Supplier<Item> regItem = Services.PLATFORM.register(BuiltInRegistries.f_257033_, new ResourceLocation("archeryexp", name), item);
        WEAPONS.add(regItem);
        return regItem;
    }

    public static void register() {
        BOWS.add(() -> Items.f_42411_);
        ArcheryExpansion.LOGGER.debug("Registering Items forarcheryexp");
    }
}

