/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.infernalstudios.archeryexp.client.TrajectoryRenderer;
import org.infernalstudios.archeryexp.client.particles.ArcheryParticles;
import org.infernalstudios.archeryexp.client.particles.HeadshotParticle;
import org.infernalstudios.archeryexp.client.particles.QuickdrawShineParticle;
import org.infernalstudios.archeryexp.client.renderer.MaterialArrowRenderer;
import org.infernalstudios.archeryexp.common.entities.ArcheryEntityTypes;
import org.infernalstudios.archeryexp.common.items.ArcheryItems;
import org.infernalstudios.archeryexp.util.BowTooltipUtil;
import org.infernalstudios.archeryexp.util.BowUtil;
import org.infernalstudios.archeryexp.util.mixinterfaces.IBowProperties;

public class ArcheryExpansionForgeClient {

    @Mod.EventBusSubscriber(modid="archeryexp", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public class WorldRenderEvents {
        @SubscribeEvent
        public static void renderTrajectory(RenderLevelStageEvent event) {
            Minecraft client = Minecraft.m_91087_();
            if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                return;
            }
            TrajectoryRenderer.render(event.getPoseStack(), (MultiBufferSource)client.m_91269_().m_110104_(), client.f_91073_, event.getPartialTick());
        }
    }

    @Mod.EventBusSubscriber(modid="archeryexp", value={Dist.CLIENT})
    public class TooltipEvents {
        @SubscribeEvent
        public static void bowTooltipEvent(ItemTooltipEvent event) {
            BowTooltipUtil.addBowTooltips(event.getToolTip(), event.getItemStack());
        }
    }

    @Mod.EventBusSubscriber(modid="archeryexp", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_(ArcheryEntityTypes.IRON_ARROW.get(), MaterialArrowRenderer::new);
            EntityRenderers.m_174036_(ArcheryEntityTypes.GOLD_ARROW.get(), MaterialArrowRenderer::new);
            EntityRenderers.m_174036_(ArcheryEntityTypes.DIAMOND_ARROW.get(), MaterialArrowRenderer::new);
            EntityRenderers.m_174036_(ArcheryEntityTypes.NETHERITE_ARROW.get(), MaterialArrowRenderer::new);
            ArcheryItems.BOWS.forEach(supplier -> {
                Item item = (Item)supplier.get();
                ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("drawing"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
                ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("draw"), (stack, world, entity, seed) -> {
                    if (entity == null || entity.m_21211_() != stack) {
                        return 0.0f;
                    }
                    IBowProperties properties = (IBowProperties)stack.m_41720_();
                    return BowUtil.getPowerForDrawTime(stack.m_41779_() - entity.m_21212_(), properties);
                });
            });
        }

        @SubscribeEvent
        public static void registerParticles(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ArcheryParticles.HEADSHOT.get(), HeadshotParticle.Factory::new);
            event.registerSpriteSet((ParticleType)ArcheryParticles.QUICKDRAW_SHINE.get(), QuickdrawShineParticle.Factory::new);
        }
    }
}

