/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.registry.DataSerializers;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityOrbitProjectile
extends EntityProjectileSpell {
    public int ticksLeft;
    public static final EntityDataAccessor<Vec3> LAST_POS = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)((EntityDataSerializer)DataSerializers.VEC.get()));
    public static final EntityDataAccessor<Integer> OFFSET = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ACCELERATES = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> AOE = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> TOTAL = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int extendTimes;
    public boolean tracksGround;

    public EntityOrbitProjectile(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), worldIn, x, y, z);
    }

    public EntityOrbitProjectile(Level worldIn, LivingEntity shooter) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), worldIn, shooter);
    }

    public EntityOrbitProjectile(Level world, SpellResolver resolver) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), world, resolver);
    }

    public EntityOrbitProjectile(Level world, SpellResolver resolver, Entity tracking) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), world, resolver);
        this.m_5602_(tracking);
        this.f_19804_.m_135381_(LAST_POS, (Object)tracking.m_20182_());
    }

    public EntityOrbitProjectile(Level world, SpellResolver resolver, Vec3 hitPos) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), world, resolver);
        this.m_5602_(null);
        this.tracksGround = true;
        this.f_19804_.m_135381_(LAST_POS, (Object)hitPos);
    }

    public EntityOrbitProjectile(EntityType<EntityOrbitProjectile> entityWardProjectileEntityType, Level world) {
        super((EntityType<? extends EntityProjectileSpell>)entityWardProjectileEntityType, world);
    }

    public void setOffset(int offset) {
        this.f_19804_.m_135381_(OFFSET, (Object)offset);
    }

    public int getOffset() {
        int val = 15;
        return (Integer)this.f_19804_.m_135370_(OFFSET) * val;
    }

    public void setTotal(int total) {
        this.f_19804_.m_135381_(TOTAL, (Object)total);
    }

    public int getTotal() {
        return (Integer)this.f_19804_.m_135370_(TOTAL) > 0 ? (Integer)this.f_19804_.m_135370_(TOTAL) : 1;
    }

    public void setAccelerates(int accelerates) {
        this.f_19804_.m_135381_(ACCELERATES, (Object)accelerates);
    }

    public int getAccelerates() {
        return (Integer)this.f_19804_.m_135370_(ACCELERATES);
    }

    public void setAoe(float aoe) {
        this.f_19804_.m_135381_(AOE, (Object)Float.valueOf(aoe));
    }

    public float getAoe() {
        return ((Float)this.f_19804_.m_135370_(AOE)).floatValue();
    }

    public double getRotateSpeed() {
        return 10.0 - (double)this.getAccelerates();
    }

    public double getRadiusMultiplier() {
        return 1.5 + 0.5 * (double)this.getAoe();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_19749_() == null) {
            this.tracksGround = true;
        }
    }

    @Override
    public Vec3 getNextHitPosition() {
        return this.getAngledPosition(this.f_19797_ + 3);
    }

    @Override
    public void tickNextPosition() {
        this.m_146884_(this.getAngledPosition(this.f_19797_));
    }

    public Vec3 getAngledPosition(int nextTick) {
        double rotateSpeed = this.getRotateSpeed();
        double radiusMultiplier = this.getRadiusMultiplier();
        Entity owner = this.m_19749_();
        if (owner == null || owner.m_213877_() || this.tracksGround) {
            Vec3 lastVec = (Vec3)this.f_19804_.m_135370_(LAST_POS);
            return new Vec3(lastVec.m_7096_() - radiusMultiplier * Math.sin((double)nextTick / rotateSpeed + (double)this.getOffset()), lastVec.m_7098_() + (this.tracksGround ? 0.5 : 0.0), lastVec.m_7094_() - radiusMultiplier * Math.cos((double)nextTick / rotateSpeed + (double)this.getOffset()));
        }
        Vec3 lastVec = new Vec3(owner.m_20185_() - radiusMultiplier * Math.sin((double)nextTick / rotateSpeed + (double)this.getOffset()), owner.m_20186_() + 1.0 - (owner.m_6144_() ? 0.25 : 0.0), owner.m_20189_() - radiusMultiplier * Math.cos((double)nextTick / rotateSpeed + (double)this.getOffset()));
        this.f_19804_.m_135381_(LAST_POS, (Object)owner.f_19825_);
        return lastVec;
    }

    @Nullable
    public Entity m_19749_() {
        return this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(OWNER_ID)).intValue());
    }

    @Override
    public boolean canTraversePortals() {
        return false;
    }

    @Override
    public int getExpirationTime() {
        return 1200 + 600 * this.extendTimes;
    }

    @Override
    protected void m_6532_(@NotNull HitResult result) {
        if (this.f_19853_.f_46443_ || result.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            if (entityHitResult.m_82443_().equals((Object)this.m_19749_()) && !this.tracksGround) {
                return;
            }
            if (this.spellResolver != null) {
                this.spellResolver.getNewResolver(this.spellResolver.spellContext.clone().makeChildContext()).onResolveEffect(this.f_19853_, result);
                Networking.sendToNearby(this.f_19853_, BlockPos.m_274446_((Position)result.m_82450_()), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, BlockPos.m_274446_((Position)result.m_82450_()), this.getParticleColor(), new int[0]));
                this.attemptRemoval();
            }
        } else if (this.numSensitive > 0 && result instanceof BlockHitResult) {
            BlockHitResult blockraytraceresult = (BlockHitResult)result;
            if (!this.m_213877_()) {
                if (this.spellResolver != null) {
                    this.spellResolver.getNewResolver(this.spellResolver.spellContext.clone().makeChildContext()).onResolveEffect(this.f_19853_, (HitResult)blockraytraceresult);
                }
                Networking.sendToNearby(this.f_19853_, ((BlockHitResult)result).m_82425_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, BlockPos.m_274446_((Position)result.m_82450_()).m_7495_(), this.getParticleColor(), new int[0]));
                this.attemptRemoval();
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OFFSET, (Object)0);
        this.f_19804_.m_135372_(ACCELERATES, (Object)0);
        this.f_19804_.m_135372_(AOE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TOTAL, (Object)0);
        this.f_19804_.m_135372_(LAST_POS, (Object)Vec3.f_82478_);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("left", this.ticksLeft);
        tag.m_128405_("offset", this.getOffset());
        tag.m_128350_("aoe", this.getAoe());
        tag.m_128405_("accelerate", this.getAccelerates());
        tag.m_128405_("total", this.getTotal());
        tag.m_128347_("lastX", ((Vec3)this.f_19804_.m_135370_(EntityOrbitProjectile.LAST_POS)).f_82479_);
        tag.m_128347_("lastY", ((Vec3)this.f_19804_.m_135370_(EntityOrbitProjectile.LAST_POS)).f_82480_);
        tag.m_128347_("lastZ", ((Vec3)this.f_19804_.m_135370_(EntityOrbitProjectile.LAST_POS)).f_82481_);
        tag.m_128379_("canHitOwner", this.tracksGround);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.ticksLeft = tag.m_128451_("left");
        this.setOffset(tag.m_128451_("offset"));
        this.setAoe(tag.m_128457_("aoe"));
        this.setAccelerates(tag.m_128451_("accelerate"));
        this.setTotal(tag.m_128451_("total"));
        this.f_19804_.m_135381_(LAST_POS, (Object)new Vec3(tag.m_128459_("lastX"), tag.m_128459_("lastY"), tag.m_128459_("lastZ")));
        this.tracksGround = tag.m_128471_("canHitOwner");
    }

    @Override
    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.ORBIT_SPELL.get();
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityOrbitProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), world);
    }
}

