/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class WildenHunterModel
extends GeoModel<WildenHunter> {
    public void setCustomAnimations(WildenHunter entity, long uniqueID, AnimationState<WildenHunter> customPredicate) {
        super.setCustomAnimations((GeoAnimatable)entity, uniqueID, customPredicate);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
        head.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
    }

    public ResourceLocation getModelResource(WildenHunter hunter) {
        return new ResourceLocation("ars_nouveau", "geo/wilden_hunter.geo.json");
    }

    public ResourceLocation getTextureResource(WildenHunter hunter) {
        return new ResourceLocation("ars_nouveau", "textures/entity/wilden_hunter.png");
    }

    public ResourceLocation getAnimationResource(WildenHunter hunter) {
        return new ResourceLocation("ars_nouveau", "animations/wilden_hunter_animations.json");
    }
}

