/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.other;

import com.teamabnormals.upgrade_aquatic.core.other.tags.UABiomeTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UABiomeModifierTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAFeatures;
import com.teamabnormals.upgrade_aquatic.core.registry.UAWorldCarvers;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class UABiomeModifiers {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        UABiomeModifiers.addFeature(context, "beachgrass", UABiomeTags.HAS_BEACHGRASS, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.BEACHGRASS_DUNES);
        UABiomeModifiers.addFeature(context, "searocket", UABiomeTags.HAS_SEAROCKET, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.PATCH_SEAROCKET);
        UABiomeModifiers.addFeature(context, "river_tree", UABiomeTags.HAS_RIVER_TREE, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.RIVER_TREE);
        UABiomeModifiers.addFeature(context, "flowering_rush", UABiomeTags.HAS_FLOWERING_RUSH, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.PATCH_FLOWERING_RUSH);
        UABiomeModifiers.addFeature(context, "pickerelweed", UABiomeTags.HAS_PICKERELWEED, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.PATCH_PICKERELWEED);
        UABiomeModifiers.addFeature(context, "pickerelweed_extra", UABiomeTags.HAS_EXTRA_PICKERELWEED, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.PATCH_PICKERELWEED_EXTRA);
        UABiomeModifiers.addFeature(context, "ammonite_ore", UABiomeTags.HAS_AMMONITE_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, UAFeatures.UAPlacedFeatures.ORE_AMMONITE);
        UABiomeModifiers.addFeature(context, "prismarine_coral", UABiomeTags.HAS_PRISMARINE_CORAL, GenerationStep.Decoration.RAW_GENERATION, UAFeatures.UAPlacedFeatures.PRISMARINE_CORAL);
        UABiomeModifiers.addFeature(context, "driftwood", UABiomeTags.HAS_DRIFTWOOD, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_OCEAN);
        UABiomeModifiers.addFeature(context, "driftwood_beach", UABiomeTags.HAS_BEACH_DRIFTWOOD, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_BEACH);
        UABiomeModifiers.addFeature(context, "driftwood_river", UABiomeTags.HAS_RIVER_DRIFTWOOD, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_RIVER);
        UABiomeModifiers.addFeature(context, "driftwood_swamp", UABiomeTags.HAS_SWAMP_DRIFTWOOD, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_SWAMP);
        UABiomeModifiers.addFeature(context, "driftwood_extra", UABiomeTags.HAS_EXTRA_DRIFTWOOD, GenerationStep.Decoration.VEGETAL_DECORATION, UAFeatures.UAPlacedFeatures.DRIFTWOOD_EXTRA);
        UABiomeModifiers.addCarver(context, "underwater_canyon", UABiomeTags.HAS_UNDERWATER_CANYON, GenerationStep.Carving.AIR, UAWorldCarvers.UAConfiguredWorldCarvers.UNDERWATER_CANYON);
        UABiomeModifiers.addSpawn(context, "thrasher", UABiomeTags.HAS_THRASHER, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.THRASHER.get(), 10, 1, 2));
        UABiomeModifiers.addSpawn(context, "nautilus", UABiomeTags.HAS_NAUTILUS, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.NAUTILUS.get(), 50, 1, 4));
        UABiomeModifiers.addSpawn(context, "lionfish", UABiomeTags.HAS_LIONFISH, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.LIONFISH.get(), 15, 1, 1));
        UABiomeModifiers.addSpawn(context, "pike", UABiomeTags.HAS_PIKE, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.PIKE.get(), 28, 1, 3));
        UABiomeModifiers.addSpawn(context, "squid", UABiomeTags.HAS_SQUID, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 2, 1, 4));
        UABiomeModifiers.addSpawn(context, "perch", UABiomeTags.HAS_PERCH, new MobSpawnSettings.SpawnerData((EntityType)UAEntityTypes.PERCH.get(), 5, 1, 6));
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        UABiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), UABiomeModifiers.featureSet(context, features), step));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        UABiomeModifiers.register(context, "add_spawn/" + name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), List.of(spawns)));
    }

    @SafeVarargs
    private static void addCarver(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Carving carving, ResourceKey<ConfiguredWorldCarver<?>> ... features) {
        UABiomeModifiers.register(context, "add_carver/" + name, () -> new UABiomeModifierTypes.AddCarversBiomeModifier((HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(biomes), UABiomeModifiers.carverSet(context, features), carving));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("upgrade_aquatic", name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(key -> context.m_255420_(Registries.f_256988_).m_255043_(key)).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static HolderSet<ConfiguredWorldCarver<?>> carverSet(BootstapContext<?> context, ResourceKey<ConfiguredWorldCarver<?>> ... carvers) {
        return HolderSet.m_205800_(Stream.of(carvers).map(key -> context.m_255420_(Registries.f_257003_).m_255043_(key)).collect(Collectors.toList()));
    }
}

