/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.levelgen.carver;

import com.mojang.serialization.Codec;
import com.teamabnormals.upgrade_aquatic.common.levelgen.carver.UnderwaterCanyonCarverConfiguration;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class UnderwaterCanyonWorldCarver
extends WorldCarver<UnderwaterCanyonCarverConfiguration> {
    public UnderwaterCanyonWorldCarver(Codec<UnderwaterCanyonCarverConfiguration> codec) {
        super(codec);
    }

    public boolean carve(CarvingContext p_190611_, UnderwaterCanyonCarverConfiguration p_190612_, ChunkAccess p_190613_, Function<BlockPos, Holder<Biome>> p_190614_, RandomSource p_190615_, Aquifer p_190616_, ChunkPos p_190617_, CarvingMask p_190618_) {
        int i = (this.m_65073_() * 2 - 1) * 16;
        double d0 = p_190617_.m_151382_(p_190615_.m_188503_(16));
        int j = p_190612_.f_159088_.m_213859_(p_190615_, (WorldGenerationContext)p_190611_);
        double d1 = p_190617_.m_151391_(p_190615_.m_188503_(16));
        float f = p_190615_.m_188501_() * ((float)Math.PI * 2);
        float f1 = p_190612_.f_158967_.m_214084_(p_190615_);
        double d2 = p_190612_.f_159089_.m_214084_(p_190615_);
        float f2 = p_190612_.f_158968_.f_158993_.m_214084_(p_190615_);
        int k = (int)((float)i * p_190612_.f_158968_.f_158992_.m_214084_(p_190615_));
        this.doCarve(p_190611_, p_190612_, p_190613_, p_190614_, p_190615_.m_188505_(), p_190616_, d0, j, d1, f2, f, f1, 0, k, d2, p_190618_);
        return true;
    }

    private void doCarve(CarvingContext p_190594_, UnderwaterCanyonCarverConfiguration p_190595_, ChunkAccess p_190596_, Function<BlockPos, Holder<Biome>> p_190597_, long p_190598_, Aquifer p_190599_, double p_190600_, double p_190601_, double p_190602_, float p_190603_, float p_190604_, float p_190605_, int p_190606_, int p_190607_, double p_190608_, CarvingMask p_190609_) {
        RandomSource random = RandomSource.m_216335_((long)p_190598_);
        float[] afloat = this.initWidthFactors(p_190594_, p_190595_, random);
        float f = 0.0f;
        float f1 = 0.0f;
        for (int i = p_190606_; i < p_190607_; ++i) {
            double d0 = 1.5 + (double)(Mth.m_14031_((float)((float)i * (float)Math.PI / (float)p_190607_)) * p_190603_);
            double d1 = d0 * p_190608_;
            d0 *= (double)p_190595_.f_158968_.f_158995_.m_214084_(random);
            d1 = this.updateVerticalRadius(p_190595_, random, d1, p_190607_, i);
            float f2 = Mth.m_14089_((float)p_190605_);
            float f3 = Mth.m_14031_((float)p_190605_);
            p_190600_ += (double)(Mth.m_14089_((float)p_190604_) * f2);
            p_190601_ += (double)f3;
            p_190602_ += (double)(Mth.m_14031_((float)p_190604_) * f2);
            p_190605_ *= 0.7f;
            p_190605_ += f1 * 0.05f;
            p_190604_ += f * 0.05f;
            f1 *= 0.8f;
            f *= 0.5f;
            f1 += (random.m_188501_() - random.m_188501_()) * random.m_188501_() * 2.0f;
            f += (random.m_188501_() - random.m_188501_()) * random.m_188501_() * 4.0f;
            if (random.m_188503_(4) == 0) continue;
            if (!UnderwaterCanyonWorldCarver.m_159367_((ChunkPos)p_190596_.m_7697_(), (double)p_190600_, (double)p_190602_, (int)i, (int)p_190607_, (float)p_190603_)) {
                return;
            }
            this.carveEllipsoid(p_190594_, p_190595_, p_190596_, p_190597_, p_190599_, p_190600_, p_190601_, p_190602_, d0, d1, random, p_190609_, (p_159082_, p_159083_, p_159084_, p_159085_, p_159086_) -> this.shouldSkip(p_159082_, afloat, p_159083_, p_159084_, p_159085_, p_159086_));
        }
    }

    private void carveEllipsoid(CarvingContext p_190754_, UnderwaterCanyonCarverConfiguration p_190755_, ChunkAccess p_190756_, Function<BlockPos, Holder<Biome>> p_190757_, Aquifer p_190758_, double p_190759_, double p_190760_, double p_190761_, double p_190762_, double p_190763_, RandomSource random, CarvingMask p_190764_, WorldCarver.CarveSkipChecker p_190765_) {
        ChunkPos chunkpos = p_190756_.m_7697_();
        double d0 = chunkpos.m_151390_();
        double d1 = chunkpos.m_151393_();
        double d2 = 16.0 + p_190762_ * 2.0;
        if (!(Math.abs(p_190759_ - d0) > d2) && !(Math.abs(p_190761_ - d1) > d2)) {
            int i = chunkpos.m_45604_();
            int j = chunkpos.m_45605_();
            int k = Math.max(Mth.m_14107_((double)(p_190759_ - p_190762_)) - i - 1, 0);
            int l = Math.min(Mth.m_14107_((double)(p_190759_ + p_190762_)) - i, 15);
            int i1 = Math.max(Mth.m_14107_((double)(p_190760_ - p_190763_)) - 1, p_190754_.m_142201_() + 1);
            int j1 = p_190756_.m_187679_() ? 0 : 7;
            int k1 = Math.min(Mth.m_14107_((double)(p_190760_ + p_190763_)) + 1, p_190754_.m_142201_() + p_190754_.m_142208_() - 1 - j1);
            int l1 = Math.max(Mth.m_14107_((double)(p_190761_ - p_190762_)) - j - 1, 0);
            int i2 = Math.min(Mth.m_14107_((double)(p_190761_ + p_190762_)) - j, 15);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (int j2 = k; j2 <= l; ++j2) {
                int k2 = chunkpos.m_151382_(j2);
                double d3 = ((double)k2 + 0.5 - p_190759_) / p_190762_;
                for (int l2 = l1; l2 <= i2; ++l2) {
                    int i3 = chunkpos.m_151391_(l2);
                    double d4 = ((double)i3 + 0.5 - p_190761_) / p_190762_;
                    if (d3 * d3 + d4 * d4 >= 1.0) continue;
                    MutableBoolean mutableboolean = new MutableBoolean(false);
                    for (int j3 = k1; j3 > i1; --j3) {
                        double d5 = ((double)j3 - 0.5 - p_190760_) / p_190763_;
                        if (p_190765_.m_159425_(p_190754_, d3, d5, d4, j3) || p_190764_.m_187594_(j2, j3, l2)) continue;
                        p_190764_.m_187585_(j2, j3, l2);
                        blockpos$mutableblockpos.m_122178_(k2, j3, i3);
                        this.carveBlock(p_190754_, p_190755_, p_190756_, p_190757_, random, p_190764_, blockpos$mutableblockpos, blockpos$mutableblockpos1, p_190758_, mutableboolean, i1);
                    }
                }
            }
        }
    }

    protected void carveBlock(CarvingContext context, UnderwaterCanyonCarverConfiguration configuration, ChunkAccess chunkAccess, Function<BlockPos, Holder<Biome>> p_190747_, RandomSource random, CarvingMask carvingMask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos mutablePos, Aquifer aquifer, MutableBoolean p_190752_, int minY) {
        BlockState state;
        BlockState blockstate = chunkAccess.m_8055_((BlockPos)pos);
        if (blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_60713_(Blocks.f_50195_)) {
            p_190752_.setTrue();
        }
        int y = pos.m_123342_();
        int magmaAndObsidianLevel = configuration.magmaAndObsidianLevel.m_142322_((WorldGenerationContext)context);
        if (!this.m_224910_((CarverConfiguration)configuration, blockstate) || y < magmaAndObsidianLevel) {
            return;
        }
        if (y <= configuration.f_159090_.m_142322_((WorldGenerationContext)context)) {
            state = f_64982_.m_76188_();
        } else if (y == magmaAndObsidianLevel) {
            float f;
            mutablePos.m_122159_((Vec3i)pos, Direction.DOWN);
            if (!chunkAccess.m_8055_((BlockPos)mutablePos).m_280296_()) {
                mutablePos.m_122173_(Direction.DOWN);
                if (!chunkAccess.m_8055_((BlockPos)mutablePos).m_280296_()) {
                    return;
                }
                mutablePos.m_122173_(Direction.UP);
                chunkAccess.m_6978_((BlockPos)mutablePos, Blocks.f_50080_.m_49966_(), false);
            }
            if ((f = random.m_188501_()) < 0.25f) {
                state = Blocks.f_50450_.m_49966_();
                chunkAccess.m_8113_((BlockPos)pos);
            } else {
                state = Blocks.f_50080_.m_49966_();
            }
        } else {
            state = aquifer.m_207104_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), 0.0);
        }
        if (state == null) {
            return;
        }
        chunkAccess.m_6978_((BlockPos)pos, state, false);
        if (aquifer.m_142203_() && !state.m_60819_().m_76178_()) {
            chunkAccess.m_8113_((BlockPos)pos);
        }
        if (p_190752_.isTrue()) {
            mutablePos.m_122159_((Vec3i)pos, Direction.DOWN);
            if (chunkAccess.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_50493_)) {
                context.m_190646_(p_190747_, chunkAccess, (BlockPos)mutablePos, !state.m_60819_().m_76178_()).ifPresent(p_190743_ -> {
                    chunkAccess.m_6978_((BlockPos)mutablePos, p_190743_, false);
                    if (!p_190743_.m_60819_().m_76178_()) {
                        chunkAccess.m_8113_((BlockPos)mutablePos);
                    }
                });
            }
        }
    }

    private float[] initWidthFactors(CarvingContext p_159061_, UnderwaterCanyonCarverConfiguration p_159062_, RandomSource p_159063_) {
        int i = p_159061_.m_142208_();
        float[] afloat = new float[i];
        float f = 1.0f;
        for (int j = 0; j < i; ++j) {
            if (j == 0 || p_159063_.m_188503_(p_159062_.f_158968_.f_158994_) == 0) {
                f = 1.0f + p_159063_.m_188501_() * p_159063_.m_188501_();
            }
            afloat[j] = f * f;
        }
        return afloat;
    }

    private double updateVerticalRadius(UnderwaterCanyonCarverConfiguration p_159026_, RandomSource p_159027_, double p_159028_, float p_159029_, float p_159030_) {
        float f = 1.0f - Mth.m_14154_((float)(0.5f - p_159030_ / p_159029_)) * 2.0f;
        float f1 = p_159026_.f_158968_.f_158996_ + p_159026_.f_158968_.f_158997_ * f;
        return (double)f1 * p_159028_ * (double)Mth.m_216283_((RandomSource)p_159027_, (float)0.75f, (float)1.0f);
    }

    private boolean shouldSkip(CarvingContext p_159074_, float[] p_159075_, double p_159076_, double p_159077_, double p_159078_, int p_159079_) {
        int i = p_159079_ - p_159074_.m_142201_();
        return (p_159076_ * p_159076_ + p_159078_ * p_159078_) * (double)p_159075_[i - 1] + p_159077_ * p_159077_ / 6.0 >= 1.0;
    }

    public boolean isStartChunk(UnderwaterCanyonCarverConfiguration configuration, RandomSource random) {
        return random.m_188501_() <= configuration.f_67859_;
    }
}

