/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block.entity;

import com.teamabnormals.upgrade_aquatic.common.block.ElderEyeBlock;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ElderEyeBlockEntity
extends BlockEntity {
    public ElderEyeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)UABlockEntityTypes.ELDER_EYE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ElderEyeBlockEntity elderEye) {
        if (level.m_46467_() % 4L == 0L && !level.f_46443_ && ((Boolean)state.m_61143_((Property)ElderEyeBlock.ACTIVE)).booleanValue()) {
            if (!(state.m_60734_() instanceof ElderEyeBlock)) {
                return;
            }
            Direction facing = (Direction)state.m_61143_((Property)ElderEyeBlock.FACING);
            int range = ElderEyeBlockEntity.calcRange(level, pos, facing);
            AABB bb = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82338_(pos.m_121945_(facing)).m_82363_((double)(facing.m_122429_() * range), 0.0, (double)(facing.m_122431_() * range));
            boolean hasEntity = level.m_45976_(Entity.class, bb).size() > 0;
            int entityDistance = -1;
            if (hasEntity) {
                for (int i = 1; i < range; ++i) {
                    BlockPos newPos = pos.m_5484_(facing, i);
                    if (level.m_45976_(LivingEntity.class, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82338_(newPos)).size() <= 0) continue;
                    entityDistance = i;
                    break;
                }
            }
            BlockState newState = (BlockState)state.m_61124_((Property)ElderEyeBlock.POWER, (Comparable)Integer.valueOf(0));
            if (hasEntity && entityDistance > -1) {
                newState = (BlockState)state.m_61124_((Property)ElderEyeBlock.POWER, (Comparable)Integer.valueOf(16 - entityDistance));
            }
            if (state != newState) {
                level.m_46597_(pos, newState);
                ((ElderEyeBlock)state.m_60734_()).updateRedstoneNeighbors(state, level, pos);
            }
        }
    }

    public static int calcRange(Level level, BlockPos pos, Direction direction) {
        int i;
        for (i = 1; i <= 15; ++i) {
            BlockPos newPos = pos.m_5484_(direction, i);
            if (!level.m_8055_(newPos).m_60831_((BlockGetter)level, pos)) continue;
            return i - 1;
        }
        return i;
    }
}

