/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.FluidPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.StatePredicateParser;
import fzzyhmstrs.emi_loot.util.LText;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public class FluidPredicateParser {
    public static Component parseFluidPredicate(FluidPredicate predicate) {
        return LText.translatable("emi_loot.fluid_predicate.base", FluidPredicateParser.parseFluidPredicateInternal(predicate));
    }

    private static Component parseFluidPredicateInternal(FluidPredicate predicate) {
        TagKey<Fluid> tag = ((FluidPredicateAccessor)predicate).getTag();
        if (tag != null) {
            return LText.translatable("emi_loot.fluid_predicate.tag", tag.f_203868_().toString());
        }
        Fluid fluid = ((FluidPredicateAccessor)predicate).getFluid();
        if (fluid != null) {
            return LText.translatable("emi_loot.fluid_predicate.fluid", BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString());
        }
        StatePropertiesPredicate statePredicate = ((FluidPredicateAccessor)predicate).getState();
        if (!statePredicate.equals(StatePropertiesPredicate.f_67658_)) {
            return StatePredicateParser.parseStatePredicate(statePredicate);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Empty or unparsable fluid predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

