/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers.generators;

import io.github.orlouge.dynamicvillagertrades.TradeOfferManager;
import io.github.orlouge.dynamicvillagertrades.trade_offers.ExtendedTradeOffer;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeGroup;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.AttributeUtils;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.Generator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public abstract class VanillaLikeGenerator
extends Generator {
    @Override
    public Optional<Map<String, TradeGroup>> generate(VillagerProfession profession) {
        if (!this.professionFilter(profession.f_35600_())) {
            return Optional.empty();
        }
        return Optional.ofNullable((Int2ObjectMap)VillagerTrades.f_35627_.get(profession)).map(tradeMap -> tradeMap.keySet().stream().sorted().map(level -> {
            String levelName = TradeOfferManager.MerchantLevel.fromId(level).result().map(Enum::name).orElse("" + level).toLowerCase();
            String group_name = level + "_" + levelName;
            VillagerTrades.ItemListing[] trades = (VillagerTrades.ItemListing[])tradeMap.get(level);
            return new Tuple((Object)group_name, (Object)this.tradeGroupAtLevel((Integer)level, levelName, trades));
        }).collect(Collectors.toMap(Tuple::m_14418_, Tuple::m_14419_, TradeGroup::merge, TreeMap::new)));
    }

    protected ExtendedTradeOffer.Factory cachedOffer(VillagerTrades.ItemListing trade, int idx, Integer level, String levelName, Map<String, Double> attributes) {
        boolean cache = trade instanceof VillagerTrades.TreasureMapForEmeralds;
        Optional<String> key = cache ? Optional.of(levelName + "_" + AttributeUtils.generateTradeAttributeName(trade, "" + idx)) : Optional.empty();
        return new ExtendedTradeOffer.Factory(trade, level, attributes, Optional.empty(), key, cache);
    }

    protected abstract boolean professionFilter(String var1);

    protected abstract TradeGroup tradeGroupAtLevel(Integer var1, String var2, VillagerTrades.ItemListing[] var3);
}

