/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers.generators;

import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.AttributeUtils;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.OneByOneVanillaLikeGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;

public class TieredItemGenerator
extends OneByOneVanillaLikeGenerator {
    @Override
    protected boolean professionFilter(String profession) {
        return profession.equals(VillagerProfession.f_35598_.f_35600_()) || profession.equals(VillagerProfession.f_35599_.f_35600_()) || profession.equals(VillagerProfession.f_35586_.f_35600_());
    }

    @Override
    protected Map<String, Double> getAttributes(VillagerTrades.ItemListing trade, Map<String, Double> defaultAttributes) {
        Optional<Item> item = AttributeUtils.getTradeItem(trade);
        String primary = item.map(TieredItemGenerator::getItemType).orElse("other");
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        if (!primary.equals("other")) {
            if (primary.equals("material")) {
                item.flatMap(m -> AttributeUtils.getIngotMaterialName(m, false)).ifPresent(material -> attributes.put((String)material, 1.0));
            } else {
                item.flatMap(AttributeUtils::getToolOrArmorMaterialName).ifPresent(material -> attributes.put((String)material, 1.0));
            }
        }
        item.flatMap(AttributeUtils::getMod).ifPresent(modname -> attributes.put((String)modname, 1.0));
        if (attributes.size() == 0) {
            attributes.putAll(defaultAttributes);
        }
        TieredItemGenerator.normalizeAttributes(attributes);
        attributes.put(primary, 1.0);
        return attributes;
    }

    private static String getItemType(Item item) {
        if (item instanceof ArmorItem) {
            return "armor";
        }
        if (item instanceof PickaxeItem) {
            return "pickaxe";
        }
        if (item instanceof ShovelItem) {
            return "shovel";
        }
        if (item instanceof AxeItem) {
            return "axe";
        }
        if (item instanceof HoeItem) {
            return "hoe";
        }
        if (item instanceof SwordItem) {
            return "sword";
        }
        if (item instanceof DiggerItem) {
            return "miningtool";
        }
        if (item instanceof TieredItem) {
            return "othertool";
        }
        if (AttributeUtils.getIngotMaterialName(item, false).isPresent()) {
            return "material";
        }
        return "other";
    }
}

