/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers.generators;

import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.AttributeUtils;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.OneByOneVanillaLikeGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.SoundType;

public class ShepherdGenerator
extends OneByOneVanillaLikeGenerator {
    @Override
    protected boolean professionFilter(String profession) {
        return profession.equals(VillagerProfession.f_35597_.f_35600_());
    }

    @Override
    protected Map<String, Double> getAttributes(VillagerTrades.ItemListing trade, Map<String, Double> defaultAttributes) {
        HashMap<String, Double> attributes;
        String primary;
        Optional<Item> item;
        block5: {
            block4: {
                item = AttributeUtils.getTradeItem(trade);
                primary = item.flatMap(ShepherdGenerator::getTradeType).orElse("other");
                attributes = new HashMap<String, Double>();
                if (primary.equals("dye") || primary.equals("bed") || primary.equals("banner") || primary.equals("carpet")) break block4;
                if (!primary.equals("wool")) break block5;
            }
            item.flatMap(AttributeUtils::getColorAttributes).ifPresent(attributes::putAll);
        }
        item.flatMap(AttributeUtils::getMod).ifPresent(modname -> attributes.put((String)modname, 1.0));
        if (attributes.size() < 2) {
            attributes.putAll(defaultAttributes);
        }
        ShepherdGenerator.normalizeAttributes(attributes);
        attributes.put(primary, 1.0);
        return attributes;
    }

    private static Optional<String> getTradeType(Item item) {
        if (item instanceof DyeItem) {
            return Optional.of("dye");
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            if (block instanceof BedBlock) {
                return Optional.of("bed");
            }
            if (block instanceof AbstractBannerBlock) {
                return Optional.of("banner");
            }
            if (block instanceof CarpetBlock) {
                return Optional.of("carpet");
            }
            if (block.m_49966_().m_60827_() == SoundType.f_56745_) {
                return Optional.of("wool");
            }
        }
        return Optional.empty();
    }
}

