/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers.generators;

import io.github.orlouge.dynamicvillagertrades.trade_offers.ExtendedTradeOffer;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeGroup;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.AttributeUtils;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.VanillaLikeGenerator;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.npc.VillagerTrades;

public class OneByOneVanillaLikeGenerator
extends VanillaLikeGenerator {
    @Override
    protected boolean professionFilter(String profession) {
        return true;
    }

    @Override
    protected TradeGroup tradeGroupAtLevel(Integer level, String levelName, VillagerTrades.ItemListing[] trades) {
        ArrayList<ExtendedTradeOffer.Factory> offers = new ArrayList<ExtendedTradeOffer.Factory>(trades.length);
        for (int i = 0; i < trades.length; ++i) {
            Map<String, Double> attributes = Map.of();
            if (trades.length > 2) {
                attributes = Map.of(AttributeUtils.generateTradeAttributeName(trades[i], levelName + "_" + i), 1.0);
            }
            attributes = this.getAttributes(trades[i], attributes);
            offers.add(this.cachedOffer(trades[i], i, level, levelName, attributes));
        }
        int min_trades = Math.min(trades.length, 2);
        return new TradeGroup(false, min_trades, min_trades, 1.0, Optional.empty(), offers, Optional.empty(), Optional.empty());
    }

    protected Map<String, Double> getAttributes(VillagerTrades.ItemListing trade, Map<String, Double> defaultAttributes) {
        return defaultAttributes;
    }
}

