/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers.generators;

import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.AttributeUtils;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.OneByOneVanillaLikeGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class MasonGenerator
extends OneByOneVanillaLikeGenerator {
    @Override
    protected boolean professionFilter(String profession) {
        return profession.equals(VillagerProfession.f_35595_.f_35600_());
    }

    @Override
    protected Map<String, Double> getAttributes(VillagerTrades.ItemListing trade, Map<String, Double> defaultAttributes) {
        Optional<Item> item = AttributeUtils.getTradeItem(trade);
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        item.flatMap(AttributeUtils::getBlockInstrument).flatMap(m -> m == NoteBlockInstrument.BASEDRUM ? item.flatMap(AttributeUtils::getColorAttributes) : Optional.empty()).map(colors -> {
            attributes.put("stone", 1.0);
            attributes.putAll((Map<String, Double>)colors);
            return true;
        }).map(x -> item.map(MasonGenerator::stoneModifier).map(s -> {
            attributes.put("raw", s.equals("raw") ? 1.0 : -1.0);
            return true;
        }).isPresent()).or(() -> {
            attributes.put("stone", -1.0);
            return Optional.of(true);
        });
        item.flatMap(AttributeUtils::getMod).ifPresent(modname -> attributes.put((String)modname, 1.0));
        if (attributes.size() < 3) {
            attributes.putAll(defaultAttributes);
        }
        MasonGenerator.normalizeAttributes(attributes);
        return attributes;
    }

    private static String stoneModifier(Item item) {
        String[] s = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_().split("_");
        for (int i = 0; i < s.length; ++i) {
            if (s[i].equals("polished")) {
                return "polished";
            }
            if (s[i].equals("chiseled")) {
                return "chiseled";
            }
            if (s[i].equals("cut")) {
                return "cut";
            }
            if (s[i].equals("smooth")) {
                return "smooth";
            }
            if (s[i].equals("glazed")) {
                return "glazed";
            }
            if (s[i].equals("bricks")) {
                return "bricks";
            }
            if (s[i].equals("brick")) {
                return "brick";
            }
            if (s[i].equals("tiles")) {
                return "tiles";
            }
            if (s[i].equals("tile")) {
                return "tile";
            }
            if (!s[i].equals("pillar")) continue;
            return "pillar";
        }
        return "raw";
    }
}

