/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers.generators;

import io.github.orlouge.dynamicvillagertrades.DynamicVillagerTradesMod;
import io.github.orlouge.dynamicvillagertrades.mixin.TradeOffersAccessor;
import io.github.orlouge.dynamicvillagertrades.trade_offers.EnchantSpecificBookFactory;
import io.github.orlouge.dynamicvillagertrades.trade_offers.ExtendedTradeOffer;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeGroup;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.AttributeUtils;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.VanillaLikeGenerator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.enchantment.ArrowDamageEnchantment;
import net.minecraft.world.item.enchantment.ArrowFireEnchantment;
import net.minecraft.world.item.enchantment.ArrowInfiniteEnchantment;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.DiggingEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.FireAspectEnchantment;
import net.minecraft.world.item.enchantment.FishingSpeedEnchantment;
import net.minecraft.world.item.enchantment.LootBonusEnchantment;
import net.minecraft.world.item.enchantment.MendingEnchantment;
import net.minecraft.world.item.enchantment.MultiShotEnchantment;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.item.enchantment.ThornsEnchantment;
import net.minecraft.world.item.enchantment.TridentChannelingEnchantment;
import net.minecraft.world.item.enchantment.TridentImpalerEnchantment;
import net.minecraft.world.item.enchantment.TridentRiptideEnchantment;
import net.minecraft.world.item.enchantment.UntouchingEnchantment;
import net.minecraft.world.item.enchantment.WaterWalkerEnchantment;
import net.minecraft.world.item.enchantment.WaterWorkerEnchantment;

public class LibrarianGenerator
extends VanillaLikeGenerator {
    private static EnchantmentAttributesGenerator enchantmentAttributesGenerator = null;

    @Override
    public void reset() {
        enchantmentAttributesGenerator = null;
    }

    @Override
    protected boolean professionFilter(String profession) {
        return profession.equals(VillagerProfession.f_35594_.f_35600_());
    }

    @Override
    protected TradeGroup tradeGroupAtLevel(Integer level, String levelName, VillagerTrades.ItemListing[] trades) {
        int i;
        if (enchantmentAttributesGenerator == null) {
            enchantmentAttributesGenerator = new EnchantmentAttributesGenerator();
        }
        ArrayList<ExtendedTradeOffer.Factory> offers = new ArrayList<ExtendedTradeOffer.Factory>();
        HashMap<CallSite, TradeGroup> subgroups = new HashMap<CallSite, TradeGroup>();
        ArrayList<VillagerTrades.EnchantBookForEmeralds> enchantedTrades = new ArrayList<VillagerTrades.EnchantBookForEmeralds>();
        ArrayList<VillagerTrades.ItemListing> regularTrades = new ArrayList<VillagerTrades.ItemListing>();
        for (i = 0; i < trades.length; ++i) {
            VillagerTrades.ItemListing itemListing = trades[i];
            if (itemListing instanceof VillagerTrades.EnchantBookForEmeralds) {
                VillagerTrades.EnchantBookForEmeralds enchantBookFactory = (VillagerTrades.EnchantBookForEmeralds)itemListing;
                enchantedTrades.add(enchantBookFactory);
                continue;
            }
            regularTrades.add(trades[i]);
        }
        for (i = 0; i < regularTrades.size(); ++i) {
            Map<String, Double> attributes = trades.length > 2 ? Map.of(AttributeUtils.generateTradeAttributeName((VillagerTrades.ItemListing)regularTrades.get(i), levelName + "_" + i), 0.3, "enchanter", -0.5) : Map.of("enchanter", -0.5);
            offers.add(this.cachedOffer((VillagerTrades.ItemListing)regularTrades.get(i), i, level, levelName, attributes));
        }
        for (i = 0; i < enchantedTrades.size(); ++i) {
            int experience = ((TradeOffersAccessor.EnchantBookFactoryAccessor)enchantedTrades.get(i)).getExperience();
            Map<String, Double> affinities = Map.of("enchanter", 1.0);
            ArrayList<ExtendedTradeOffer.Factory> suboffers = new ArrayList<ExtendedTradeOffer.Factory>();
            for (Tuple<Enchantment, Integer> enchantment : enchantmentAttributesGenerator.getAllEnchantments()) {
                Map<String, Double> attributes = enchantmentAttributesGenerator.getAttributes((Enchantment)enchantment.m_14418_(), (Integer)enchantment.m_14419_());
                EnchantSpecificBookFactory trade = new EnchantSpecificBookFactory(experience, BuiltInRegistries.f_256876_.m_7981_((Object)((Enchantment)enchantment.m_14418_())), (Integer)enchantment.m_14419_());
                Optional<String> key = Optional.empty();
                if (DynamicVillagerTradesMod.NO_BOOK_DUPLICATES) {
                    key = Optional.of("" + BuiltInRegistries.f_256876_.m_7981_((Object)((Enchantment)enchantment.m_14418_())));
                }
                suboffers.add(new ExtendedTradeOffer.Factory(trade, level, attributes, Optional.empty(), key, false));
            }
            subgroups.put((CallSite)((Object)((i + 1) * level + "_enchanted_books_" + levelName)), new TradeGroup(false, 0, 1, 0.1, Optional.of(affinities), suboffers, Optional.empty(), Optional.empty()));
        }
        int min_trades = Math.min(trades.length, 2);
        return new TradeGroup(false, min_trades, min_trades, 1.0, Optional.empty(), offers, Optional.of(subgroups), Optional.of("enchantments"));
    }

    private static class EnchantmentAttributesGenerator {
        private final Map<Enchantment, Map<String, Double>> levelIndependentAttributes = this.getLevelIndependentAttributes(1.0, 1.0, 3);
        private static final Set<String> blacklistedKeywords = Set.of("of", "the", "curse");
        private static final Map<String, String> knownKeywords = Map.ofEntries(Map.entry("fire", "fire"), Map.entry("flame", "fire"), Map.entry("lava", "fire"), Map.entry("magma", "fire"), Map.entry("pyromania", "fire"), Map.entry("burn", "fire"), Map.entry("blaze", "fire"), Map.entry("burning", "fire"), Map.entry("smelt", "fire"), Map.entry("forge", "fire"), Map.entry("blast", "explosion"), Map.entry("explosion", "explosion"), Map.entry("exploding", "explosion"), Map.entry("arrow", "ranged"), Map.entry("projectile", "ranged"), Map.entry("shot", "ranged"), Map.entry("ranged", "ranged"), Map.entry("shotgun", "ranged"), Map.entry("sniper", "ranged"), Map.entry("melee", "melee"), Map.entry("hit", "melee"), Map.entry("critical", "melee"), Map.entry("swift", "speed"), Map.entry("efficiency", "speed"), Map.entry("quick", "speed"), Map.entry("speed", "speed"), Map.entry("looting", "luck"), Map.entry("luck", "luck"), Map.entry("lucky", "luck"), Map.entry("fortune", "luck"), Map.entry("aspect", "aspect"), Map.entry("protection", "defense"), Map.entry("defense", "defense"), Map.entry("tank", "defense"), Map.entry("resistance", "defense"), Map.entry("water", "water"), Map.entry("sea", "water"), Map.entry("ocean", "water"), Map.entry("aqua", "water"), Map.entry("frost", "water"), Map.entry("ice", "water"), Map.entry("freezing", "water"), Map.entry("glacial", "water"), Map.entry("respiration", "water"), Map.entry("channeling", "thunder"), Map.entry("thunder", "thunder"), Map.entry("poison", "poison"));
        private static final Map<String, String> negativeAttributes = Map.of("water", "fire", "ranged", "melee");

        public Collection<Tuple<Enchantment, Integer>> getAllEnchantments() {
            return this.levelIndependentAttributes.keySet().stream().flatMap(ench -> IntStream.range(ench.m_44702_(), ench.m_6586_() + 1).mapToObj(level -> new Tuple(ench, (Object)level))).collect(Collectors.toList());
        }

        public Map<String, Double> getAttributes(Enchantment enchantment, int level) {
            HashMap<String, Double> attributes = new HashMap<String, Double>(this.levelIndependentAttributes.getOrDefault(enchantment, new HashMap()));
            double levelRatio = ((double)enchantment.m_6586_() - (double)level) / (double)enchantment.m_6586_();
            attributes.put("low_level", levelRatio * 2.0 - 1.0);
            attributes.put("enchanter", 1.0);
            return attributes;
        }

        private Map<Enchantment, Map<String, Double>> getLevelIndependentAttributes(double primary, double secondary, int nSecondaryAttributes) {
            HashMap<Enchantment, Map<String, Double>> attributes = new HashMap<Enchantment, Map<String, Double>>();
            HashMap candidateSecondaryAttributes = new HashMap();
            BuiltInRegistries.f_256876_.forEach(enchantment -> {
                if (!enchantment.m_6594_()) {
                    return;
                }
                HashMap<String, Double> enchantmentAttributes = new HashMap<String, Double>();
                enchantmentAttributes.put(this.getPrimaryAttribute((Enchantment)enchantment), primary);
                attributes.put((Enchantment)enchantment, (Map<String, Double>)enchantmentAttributes);
                candidateSecondaryAttributes.put(enchantment, this.getCandidateSecondaryAttributes((Enchantment)enchantment));
            });
            for (Map.Entry secondaryAttributes : AttributeUtils.generateUniqueAttributeSets(candidateSecondaryAttributes, nSecondaryAttributes).entrySet()) {
                Map enchantmentAttributes = (Map)attributes.get(secondaryAttributes.getKey());
                if (enchantmentAttributes == null) continue;
                for (String secondaryAttribute : secondaryAttributes.getValue()) {
                    double attributeValue = secondary / (double)secondaryAttributes.getValue().size();
                    if (negativeAttributes.containsKey(secondaryAttribute)) {
                        enchantmentAttributes.putIfAbsent(negativeAttributes.get(secondaryAttribute), -attributeValue);
                        continue;
                    }
                    enchantmentAttributes.putIfAbsent(secondaryAttribute, attributeValue);
                }
            }
            return attributes;
        }

        private Map<String, Integer> getCandidateSecondaryAttributes(Enchantment enchantment) {
            HashMap<String, Integer> attributes = new HashMap<String, Integer>();
            if (enchantment.m_6589_()) {
                attributes.put("curse", 10000);
            }
            if (enchantment.m_6591_()) {
                attributes.put("treasure", 10000);
            }
            if (enchantment instanceof ProtectionEnchantment) {
                attributes.put("defense", 1000);
            }
            if (enchantment instanceof LootBonusEnchantment) {
                attributes.put("luck", 1000);
            }
            if (enchantment.f_44672_ == EnchantmentCategory.BOW || enchantment.f_44672_ == EnchantmentCategory.CROSSBOW || enchantment.f_44672_ == EnchantmentCategory.TRIDENT) {
                attributes.put("ranged", 100);
            }
            if (enchantment.f_44672_ == EnchantmentCategory.TRIDENT || enchantment.f_44672_ == EnchantmentCategory.FISHING_ROD) {
                attributes.put("water", 100);
            }
            if (enchantment.f_44672_ == EnchantmentCategory.WEAPON) {
                attributes.put("melee", 100);
            }
            if (enchantment instanceof DamageEnchantment || enchantment instanceof ArrowDamageEnchantment || enchantment instanceof TridentImpalerEnchantment) {
                attributes.put("offense", 10);
            }
            if (enchantment instanceof FireAspectEnchantment || enchantment instanceof TridentChannelingEnchantment || enchantment instanceof MultiShotEnchantment || enchantment instanceof ThornsEnchantment) {
                attributes.put("offense", 10);
            }
            if (enchantment instanceof ThornsEnchantment) {
                attributes.put("melee", 100);
            }
            if (enchantment instanceof DigDurabilityEnchantment || enchantment instanceof MendingEnchantment || enchantment instanceof UntouchingEnchantment || enchantment instanceof ArrowInfiniteEnchantment) {
                attributes.put("resource", 10);
            }
            if (enchantment instanceof WaterWorkerEnchantment || enchantment instanceof DiggingEnchantment || enchantment instanceof WaterWalkerEnchantment || enchantment instanceof FishingSpeedEnchantment || enchantment instanceof TridentRiptideEnchantment) {
                attributes.put("speed", 100);
            }
            if (this.isFire(enchantment)) {
                attributes.put("fire", 100);
            }
            if (enchantment.f_44672_ == EnchantmentCategory.ARMOR_CHEST) {
                attributes.put("armor_chest", 2);
            }
            if (enchantment.f_44672_ == EnchantmentCategory.ARMOR_FEET) {
                attributes.put("armor_feet", 2);
            }
            if (enchantment.f_44672_ == EnchantmentCategory.ARMOR_LEGS) {
                attributes.put("armor_legs", 2);
            }
            if (enchantment.f_44672_ == EnchantmentCategory.ARMOR_HEAD) {
                attributes.put("armor_head", 2);
            }
            Optional.ofNullable(BuiltInRegistries.f_256876_.m_7981_((Object)enchantment)).ifPresent(id -> {
                List<String> keywords = List.of(id.m_135815_().split("_"));
                for (String keyword : keywords) {
                    String attribute = knownKeywords.get(keyword);
                    if (attribute != null) {
                        attributes.put(attribute, 10);
                        continue;
                    }
                    if (blacklistedKeywords.contains(keyword)) continue;
                    attributes.put(keyword, 2);
                }
                attributes.put(id.m_135815_(), 3);
                if (!id.m_135827_().equals("minecraft")) {
                    attributes.put(id.m_135827_(), 1000);
                }
            });
            return attributes;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isFire(Enchantment enchantment) {
            if (enchantment instanceof FireAspectEnchantment) return true;
            if (enchantment instanceof ArrowFireEnchantment) return true;
            if (!(enchantment instanceof ProtectionEnchantment)) return false;
            ProtectionEnchantment prot = (ProtectionEnchantment)enchantment;
            if (prot.f_45124_ != ProtectionEnchantment.Type.FIRE) return false;
            return true;
        }

        private String getPrimaryAttribute(Enchantment enchantment) {
            return switch (enchantment.f_44672_) {
                case EnchantmentCategory.ARMOR, EnchantmentCategory.ARMOR_HEAD, EnchantmentCategory.ARMOR_LEGS, EnchantmentCategory.ARMOR_CHEST, EnchantmentCategory.ARMOR_FEET, EnchantmentCategory.WEARABLE -> "armor";
                case EnchantmentCategory.BOW -> "bow";
                case EnchantmentCategory.CROSSBOW -> "crossbow";
                case EnchantmentCategory.DIGGER -> "tool";
                case EnchantmentCategory.FISHING_ROD -> "fishing";
                case EnchantmentCategory.TRIDENT -> "trident";
                case EnchantmentCategory.WEAPON -> "weapon";
                default -> "all";
            };
        }
    }
}

