/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers.generators;

import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeGroup;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.FletcherGenerator;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.LibrarianGenerator;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.MasonGenerator;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.OneByOneVanillaLikeGenerator;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.ShepherdGenerator;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.TieredItemGenerator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.npc.VillagerProfession;

public abstract class Generator {
    private static List<Generator> generators = List.of(new TieredItemGenerator(), new MasonGenerator(), new LibrarianGenerator(), new ShepherdGenerator(), new FletcherGenerator(), new OneByOneVanillaLikeGenerator());

    public void reset() {
    }

    public abstract Optional<Map<String, TradeGroup>> generate(VillagerProfession var1);

    public static Optional<Map<String, TradeGroup>> generateAll(VillagerProfession profession) {
        for (Generator generator : generators) {
            Optional<Map<String, TradeGroup>> trades = generator.generate(profession);
            if (!trades.isPresent()) continue;
            return trades;
        }
        return Optional.empty();
    }

    public static void resetAll() {
        for (Generator generator : generators) {
            generator.reset();
        }
    }

    protected static void normalizeAttributes(Map<String, Double> attributes) {
        double sum = attributes.values().stream().map(Math::abs).reduce(0.0, Double::sum);
        double finalSum = sum > 0.0 ? sum : 1.0;
        attributes.replaceAll((attr, value) -> 2.0 * value / finalSum);
    }
}

