/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers.generators;

import io.github.orlouge.dynamicvillagertrades.mixin.TradeOffersAccessor;
import io.github.orlouge.dynamicvillagertrades.trade_offers.ExtendedTradeOffer;
import io.github.orlouge.dynamicvillagertrades.trade_offers.SellSpecificPotionHoldingItemFactory;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeGroup;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.AttributeUtils;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.VanillaLikeGenerator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;

public class FletcherGenerator
extends VanillaLikeGenerator {
    private static PotionAttributesGenerator potionAttributesGenerator = null;

    @Override
    public void reset() {
        potionAttributesGenerator = null;
    }

    @Override
    protected boolean professionFilter(String profession) {
        return profession.equals(VillagerProfession.f_35592_.f_35600_());
    }

    @Override
    protected TradeGroup tradeGroupAtLevel(Integer level, String levelName, VillagerTrades.ItemListing[] trades) {
        int i;
        if (potionAttributesGenerator == null) {
            potionAttributesGenerator = new PotionAttributesGenerator();
        }
        ArrayList<ExtendedTradeOffer.Factory> offers = new ArrayList<ExtendedTradeOffer.Factory>();
        HashMap<CallSite, TradeGroup> subgroups = new HashMap<CallSite, TradeGroup>();
        ArrayList<VillagerTrades.TippedArrowForItemsAndEmeralds> potionHoldingTrades = new ArrayList<VillagerTrades.TippedArrowForItemsAndEmeralds>();
        ArrayList<VillagerTrades.ItemListing> regularTrades = new ArrayList<VillagerTrades.ItemListing>();
        for (i = 0; i < trades.length; ++i) {
            VillagerTrades.ItemListing itemListing = trades[i];
            if (itemListing instanceof VillagerTrades.TippedArrowForItemsAndEmeralds) {
                VillagerTrades.TippedArrowForItemsAndEmeralds potionHoldingItemFactory = (VillagerTrades.TippedArrowForItemsAndEmeralds)itemListing;
                potionHoldingTrades.add(potionHoldingItemFactory);
                continue;
            }
            regularTrades.add(trades[i]);
        }
        for (i = 0; i < regularTrades.size(); ++i) {
            String trade_name;
            double tipped = AttributeUtils.getTradeItem((VillagerTrades.ItemListing)regularTrades.get(i)).map(item -> item instanceof ArrowItem ? 1.0 : -0.1).orElse(-0.1);
            Map<String, Double> attributes = Map.of("arrow", tipped);
            if (trades.length > 2 && !(trade_name = AttributeUtils.generateTradeAttributeName((VillagerTrades.ItemListing)regularTrades.get(i), levelName + "_" + i)).equals("arrow")) {
                attributes = Map.of(trade_name, 0.3, "arrow", tipped);
            }
            offers.add(this.cachedOffer((VillagerTrades.ItemListing)regularTrades.get(i), i, level, levelName, attributes));
        }
        for (i = 0; i < potionHoldingTrades.size(); ++i) {
            TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor accessor = (TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor)potionHoldingTrades.get(i);
            Map<String, Double> affinities = Map.of("arrow", 1.0);
            ArrayList<ExtendedTradeOffer.Factory> suboffers = new ArrayList<ExtendedTradeOffer.Factory>();
            for (Potion potion : potionAttributesGenerator.getAllPotions()) {
                Map<String, Double> attributes = potionAttributesGenerator.getAttributes(potion);
                SellSpecificPotionHoldingItemFactory trade = new SellSpecificPotionHoldingItemFactory(accessor.getSecondBuy(), accessor.getSecondCount(), accessor.getSell().m_41720_(), accessor.getSellCount(), accessor.getPrice(), accessor.getMaxUses(), accessor.getExperience(), BuiltInRegistries.f_256980_.m_7981_((Object)potion));
                suboffers.add(new ExtendedTradeOffer.Factory(trade, level, attributes, Optional.empty(), Optional.empty(), false));
            }
            subgroups.put((CallSite)((Object)((i + 1) * level + "_potion_holding_" + levelName)), new TradeGroup(false, 0, 1, 0.3, Optional.of(affinities), suboffers, Optional.empty(), Optional.empty()));
        }
        int min_trades = Math.min(trades.length, 2);
        return new TradeGroup(false, min_trades, min_trades, 1.0, Optional.empty(), offers, Optional.of(subgroups), Optional.empty());
    }

    private static class PotionAttributesGenerator {
        private final Map<Potion, Map<String, Double>> allPotionAttributes = this.getAllAttributes(1.0, 3.0, 4);

        private PotionAttributesGenerator() {
        }

        public Collection<Potion> getAllPotions() {
            return this.allPotionAttributes.keySet();
        }

        public Map<String, Double> getAttributes(Potion potion) {
            return this.allPotionAttributes.getOrDefault(potion, Collections.emptyMap());
        }

        private Map<Potion, Map<String, Double>> getAllAttributes(double primary, double secondary, int nSecondaryAttributes) {
            HashMap<Potion, Map<String, Double>> attributes = new HashMap<Potion, Map<String, Double>>();
            HashMap candidateSecondaryAttributes = new HashMap();
            BuiltInRegistries.f_256980_.forEach(potion -> {
                if (potion.m_43488_().isEmpty() || !PotionBrewing.m_43511_((Potion)potion)) {
                    return;
                }
                HashMap<String, Double> potionAttributes = new HashMap<String, Double>(this.getPrimaryAttributes((Potion)potion));
                attributes.put((Potion)potion, (Map<String, Double>)potionAttributes);
                candidateSecondaryAttributes.put(potion, this.getSecondaryAttributes((Potion)potion));
            });
            for (Map.Entry secondaryAttributes : AttributeUtils.generateUniqueAttributeSets(candidateSecondaryAttributes, nSecondaryAttributes).entrySet()) {
                Map potionAttributes = (Map)attributes.get(secondaryAttributes.getKey());
                if (potionAttributes == null) continue;
                for (String secondaryAttribute : secondaryAttributes.getValue()) {
                    double attributeValue = secondary / (double)secondaryAttributes.getValue().size();
                    potionAttributes.putIfAbsent(secondaryAttribute, attributeValue);
                }
            }
            return attributes;
        }

        private Map<String, Double> getPrimaryAttributes(Potion potion) {
            String name = BuiltInRegistries.f_256980_.m_7981_((Object)potion).m_135815_();
            if (name.startsWith("long_")) {
                return Map.of("long", 0.5, "strong", -0.1);
            }
            if (name.startsWith("strong_")) {
                return Map.of("long", -0.1, "strong", 0.5);
            }
            return Map.of("long", -0.01, "strong", -0.01);
        }

        private Map<String, Integer> getSecondaryAttributes(Potion potion) {
            HashMap<String, Integer> attributes = new HashMap<String, Integer>();
            ResourceLocation id = BuiltInRegistries.f_256980_.m_7981_((Object)potion);
            for (MobEffectInstance effect : potion.m_43488_()) {
                for (String attribute : PotionAttributesGenerator.getStatusEffectAttributes(effect.m_19544_())) {
                    attributes.put(attribute, 10);
                }
            }
            if (!id.m_135827_().equals("minecraft")) {
                attributes.put(id.m_135827_(), 100);
            }
            attributes.put(id.m_135815_().replace("long_", "").replace("strong_", ""), 1);
            attributes.put(id.m_135815_(), 0);
            return attributes;
        }

        private static Set<String> getStatusEffectAttributes(MobEffect statusEffect) {
            HashSet<String> attributes = new HashSet<String>();
            if (statusEffect.m_19483_() == MobEffectCategory.BENEFICIAL) {
                attributes.add("beneficial");
            } else if (statusEffect.m_19483_() == MobEffectCategory.NEUTRAL) {
                attributes.add("neutral");
            } else if (statusEffect.m_19483_() == MobEffectCategory.HARMFUL) {
                attributes.add("harmful");
            }
            if (statusEffect.m_8093_()) {
                attributes.add("instant");
            } else {
                attributes.add("continuous");
            }
            ResourceLocation id = BuiltInRegistries.f_256974_.m_7981_((Object)statusEffect);
            if (id != null) {
                String name;
                if (!id.m_135827_().equals("minecraft")) {
                    attributes.add(id.m_135827_());
                }
                if ((name = id.m_135815_()).equals("regeneration") || name.equals("instant_damage") || name.equals("wither") || name.equals("absorption") || name.equals("instant_health") || name.equals("health_boost") || name.equals("poison")) {
                    attributes.add("health");
                }
                if (name.contains("resistance")) {
                    attributes.add("resistance");
                }
                if (name.equals("strength") || name.equals("weakness")) {
                    attributes.add("strength");
                }
                if (name.equals("luck") || name.equals("unluck") || name.equals("bad_omen")) {
                    attributes.add("luck");
                }
                if (name.equals("saturation") || name.equals("hunger")) {
                    attributes.add("hunger");
                }
                if (name.equals("water_breathing") || name.equals("conduit_power") || name.equals("dolphins_grace")) {
                    attributes.add("water");
                }
                if (name.equals("saturation") || name.equals("hunger") || name.equals("nausea")) {
                    attributes.add("food");
                }
                if (name.equals("night_vision") || name.equals("invisibility") || name.equals("nausea") || name.equals("blindness") || name.equals("glowing")) {
                    attributes.add("vision");
                }
                if (name.equals("speed") || name.equals("slowness") || name.equals("conduit_power") || name.equals("dolphins_grace") || name.equals("haste") || name.equals("mining_fatigue")) {
                    attributes.add("speed");
                }
                if (name.equals("speed") || name.equals("slowness") || name.equals("conduit_power") || name.equals("dolphins_grace") || name.equals("slow_falling") || name.equals("jump_boost") || name.equals("levitation")) {
                    attributes.add("movement");
                }
            }
            return attributes;
        }
    }
}

