/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers.generators;

import io.github.orlouge.dynamicvillagertrades.mixin.TradeOffersAccessor;
import io.github.orlouge.dynamicvillagertrades.trade_offers.EnchantSpecificBookFactory;
import io.github.orlouge.dynamicvillagertrades.trade_offers.SellSpecificPotionHoldingItemFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public class AttributeUtils {
    public static <T> Map<T, Set<String>> generateUniqueAttributeSets(Map<T, Map<String, Integer>> candidateAttributes, int nSecondaryAttributes) {
        Integer previousPriority;
        HashMap<String, Integer> attributePriority = new HashMap<String, Integer>();
        HashMap<String, HashSet> attributeEntries = new HashMap<String, HashSet>();
        HashSet<T> entriesNeedingAttributes = new HashSet<T>();
        for (Map.Entry<T, Map<String, Integer>> entry : candidateAttributes.entrySet()) {
            for (Map.Entry<String, Integer> entry2 : entry.getValue().entrySet()) {
                previousPriority = attributePriority.getOrDefault(entry2.getKey(), 0);
                attributePriority.put(entry2.getKey(), previousPriority + entry2.getValue());
                Set entriesSet = attributeEntries.computeIfAbsent(entry2.getKey(), s -> new HashSet());
                entriesSet.add(entry.getKey());
            }
            entriesNeedingAttributes.add(entry.getKey());
        }
        HashMap<Set, Integer> entrieSetPriorities = new HashMap<Set, Integer>();
        for (Map.Entry entry : attributeEntries.entrySet()) {
            Integer n = attributePriority.getOrDefault(entry.getKey(), 0);
            previousPriority = (Integer)entrieSetPriorities.get(entry.getValue());
            if (previousPriority == null) {
                entrieSetPriorities.put((Set)entry.getValue(), n);
                continue;
            }
            if (n <= previousPriority) continue;
            entrieSetPriorities.put((Set)entry.getValue(), n);
            attributePriority.remove(entry.getKey());
        }
        PriorityQueue<Map.Entry> priorityQueue = new PriorityQueue<Map.Entry>(Comparator.comparing(Map.Entry::getValue).reversed());
        HashMap<Object, Set> hashMap = new HashMap<Object, Set>();
        priorityQueue.addAll(attributePriority.entrySet());
        block3: while (entriesNeedingAttributes.size() > 0 && priorityQueue.size() > 0) {
            Set attributeSet;
            String string = (String)priorityQueue.poll().getKey();
            HashSet<Set> attributeSets = new HashSet<Set>();
            for (Object entry : (HashSet)attributeEntries.get(string)) {
                if (!entriesNeedingAttributes.contains(entry)) continue block3;
                attributeSet = hashMap.getOrDefault(entry, new HashSet());
                if (attributeSet.size() < nSecondaryAttributes - 1) continue;
                if (attributeSets.contains(attributeSet)) continue block3;
                attributeSets.add(attributeSet);
            }
            for (Object entry : (HashSet)attributeEntries.get(string)) {
                attributeSet = hashMap.computeIfAbsent(entry, s -> new HashSet());
                attributeSet.add(string);
                if (attributeSet.size() != nSecondaryAttributes) continue;
                entriesNeedingAttributes.remove(entry);
            }
        }
        return hashMap;
    }

    public static Optional<Item> getTradeItem(VillagerTrades.ItemListing factory) {
        if (factory instanceof VillagerTrades.EmeraldForItems) {
            VillagerTrades.EmeraldForItems buyfactory = (VillagerTrades.EmeraldForItems)factory;
            return Optional.of(((TradeOffersAccessor.BuyForOneEmeraldFactoryAccessor)buyfactory).getBuy());
        }
        if (factory instanceof VillagerTrades.ItemsForEmeralds) {
            VillagerTrades.ItemsForEmeralds sellfactory = (VillagerTrades.ItemsForEmeralds)factory;
            return Optional.of(((TradeOffersAccessor.SellItemFactoryAccessor)sellfactory).getSell().m_41720_());
        }
        if (factory instanceof VillagerTrades.ItemsAndEmeraldsToItems) {
            VillagerTrades.ItemsAndEmeraldsToItems processfactory = (VillagerTrades.ItemsAndEmeraldsToItems)factory;
            return Optional.of(((TradeOffersAccessor.ProcessItemFactoryAccessor)processfactory).getSell().m_41720_());
        }
        if (factory instanceof VillagerTrades.EnchantedItemForEmeralds) {
            VillagerTrades.EnchantedItemForEmeralds sellfactory = (VillagerTrades.EnchantedItemForEmeralds)factory;
            return Optional.of(((TradeOffersAccessor.SellEnchantedToolFactoryAccessor)sellfactory).getTool().m_41720_());
        }
        if (factory instanceof VillagerTrades.EmeraldsForVillagerTypeItem) {
            VillagerTrades.EmeraldsForVillagerTypeItem buyfactory = (VillagerTrades.EmeraldsForVillagerTypeItem)factory;
            return ((TradeOffersAccessor.TypeAwareBuyForOneEmeraldFactoryAccessor)buyfactory).getMap().values().stream().findFirst();
        }
        if (factory instanceof VillagerTrades.TippedArrowForItemsAndEmeralds) {
            VillagerTrades.TippedArrowForItemsAndEmeralds sellfactory = (VillagerTrades.TippedArrowForItemsAndEmeralds)factory;
            return Optional.of(((TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor)sellfactory).getSell().m_41720_());
        }
        if (factory instanceof VillagerTrades.DyedArmorForEmeralds) {
            VillagerTrades.DyedArmorForEmeralds sellfactory = (VillagerTrades.DyedArmorForEmeralds)factory;
            return Optional.of(((TradeOffersAccessor.SellDyedArmorFactoryAccessor)sellfactory).getSell());
        }
        return Optional.empty();
    }

    public static String generateTradeAttributeName(VillagerTrades.ItemListing factory, String fallback) {
        VillagerTrades.SuspiciousStewForEmerald stewfactory;
        Optional entry;
        if (factory instanceof VillagerTrades.SuspiciousStewForEmerald && (entry = BuiltInRegistries.f_256974_.m_203300_(MobEffect.m_19459_((MobEffect)((TradeOffersAccessor.SellSuspiciousStewFactoryAccessor)(stewfactory = (VillagerTrades.SuspiciousStewForEmerald)factory)).getEffect()))).isPresent() && ((Holder.Reference)entry.get()).m_203543_().isPresent()) {
            return ((ResourceKey)((Holder.Reference)entry.get()).m_203543_().get()).m_135782_().m_135815_();
        }
        if (factory instanceof VillagerTrades.EnchantBookForEmeralds) {
            return "enchanted_book";
        }
        if (factory instanceof VillagerTrades.TreasureMapForEmeralds) {
            VillagerTrades.TreasureMapForEmeralds sellfactory = (VillagerTrades.TreasureMapForEmeralds)factory;
            ResourceKey key = ((TradeOffersAccessor.SellMapFactoryAccessor)sellfactory).getStructure().f_203867_();
            return key.m_135782_().m_135815_();
        }
        if (factory instanceof EnchantSpecificBookFactory) {
            EnchantSpecificBookFactory enchantfactory = (EnchantSpecificBookFactory)factory;
            return enchantfactory.getEnchantmentType().m_135815_();
        }
        if (factory instanceof SellSpecificPotionHoldingItemFactory) {
            SellSpecificPotionHoldingItemFactory sellpotionfactory = (SellSpecificPotionHoldingItemFactory)factory;
            return sellpotionfactory.getPotion().m_135815_();
        }
        return AttributeUtils.getTradeItem(factory).map(i -> BuiltInRegistries.f_257033_.m_7981_(i).m_135815_()).orElse(fallback);
    }

    public static Optional<NoteBlockInstrument> getBlockInstrument(Item item) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return Optional.of(blockItem.m_40614_().m_49966_().m_280603_());
        }
        return Optional.empty();
    }

    public static Optional<MapColor> getColor(Item item) {
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            return Optional.of(dyeItem.m_41089_().m_284406_());
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            if (block instanceof BedBlock) {
                BedBlock bed = (BedBlock)block;
                return Optional.of(bed.m_49554_().m_284406_());
            }
            if (block instanceof BannerBlock) {
                BannerBlock banner = (BannerBlock)block;
                return Optional.of(banner.m_48674_().m_284406_());
            }
            return Optional.of(block.m_284356_());
        }
        return Optional.empty();
    }

    public static Optional<Map<String, Double>> getColorAttributes(Item item) {
        return AttributeUtils.getColor(item).map(mapColor -> {
            int red = mapColor.f_283871_ >> 16 & 0xFF;
            int green = mapColor.f_283871_ >> 8 & 0xFF;
            int blue = mapColor.f_283871_ & 0xFF;
            int max = Math.max(red, Math.max(green, blue));
            int min = Math.min(red, Math.min(green, blue));
            double redness = ((double)red - (double)min) / 255.0;
            double greenness = ((double)green - (double)min) / 255.0;
            double blueness = ((double)blue - (double)min) / 255.0;
            double brightness = ((double)red + (double)blue + (double)green) / 382.0 - 1.0;
            double saturation = ((double)max - (double)min) / 127.0 - 1.0;
            redness = redness > 0.25 ? redness : 0.0;
            greenness = greenness > 0.25 ? greenness : 0.0;
            blueness = blueness > 0.25 ? blueness : 0.0;
            brightness = Math.abs(brightness) > 0.25 ? brightness : 0.0;
            saturation = Math.abs(saturation) > 0.25 ? saturation : 0.0;
            double sum = redness + greenness + blueness + Math.abs(brightness) + Math.abs(saturation);
            sum = sum > 0.0 ? sum : 1.0;
            return Map.of("red", redness / sum, "green", greenness / sum, "blue", blueness / sum, "saturation", saturation / sum, "brightness", brightness / sum);
        });
    }

    public static Optional<ArmorMaterial> getArmorMaterial(Item item) {
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return Optional.of(armorItem.m_40401_());
        }
        return Optional.empty();
    }

    public static Optional<Tier> getToolMaterial(Item item) {
        if (item instanceof TieredItem) {
            TieredItem toolItem = (TieredItem)item;
            return Optional.of(toolItem.m_43314_());
        }
        return Optional.empty();
    }

    public static Optional<Item> getRepairItem(Ingredient ingredient) {
        ItemStack[] matchingStacks = ingredient.m_43908_();
        if (matchingStacks.length > 0) {
            return Optional.of(matchingStacks[0].m_41720_());
        }
        return Optional.empty();
    }

    public static Optional<String> getMod(Item item) {
        String namespace = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135827_();
        return namespace == "minecraft" ? Optional.empty() : Optional.of(namespace);
    }

    public static Optional<String> getIngotMaterialName(Item item, boolean alwaysReturn) {
        String name = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
        if (name.endsWith("_ingot")) {
            return Optional.of(name.replace("_ingot", ""));
        }
        if (name.equals("diamond")) {
            return Optional.of("diamond");
        }
        if (alwaysReturn) {
            return Optional.of(name.split("_")[0]);
        }
        return Optional.empty();
    }

    public static Optional<String> getToolOrArmorMaterialName(Item item) {
        return AttributeUtils.getArmorMaterial(item).map(ArmorMaterial::m_6082_).or(() -> AttributeUtils.getToolMaterial(item).map(Tier::m_6282_).or(() -> AttributeUtils.getArmorMaterial(item).map(ArmorMaterial::m_6230_)).flatMap(AttributeUtils::getRepairItem).flatMap(m -> AttributeUtils.getIngotMaterialName(m, true)));
    }

    public static Optional<EquipmentSlot> getArmorType(Item item) {
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return Optional.of(armorItem.m_40402_());
        }
        return Optional.empty();
    }
}

