/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.dynamicvillagertrades.api.CodecHelper;
import io.github.orlouge.dynamicvillagertrades.mixin.TradeOffersAccessor;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeOfferFactoryType;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.saveddata.maps.MapDecoration;

public class VanillaTradeOfferFactories {
    public static final Codec<VillagerTrades.EmeraldForItems> BUY_FOR_ONE_EMERALD = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(factory -> ((TradeOffersAccessor.BuyForOneEmeraldFactoryAccessor)factory).getBuy()), (App)Codec.INT.fieldOf("price").forGetter(factory -> ((TradeOffersAccessor.BuyForOneEmeraldFactoryAccessor)factory).getPrice()), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> ((TradeOffersAccessor.BuyForOneEmeraldFactoryAccessor)factory).getMaxUses()), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> ((TradeOffersAccessor.BuyForOneEmeraldFactoryAccessor)factory).getExperience())).apply((Applicative)instance, VillagerTrades.EmeraldForItems::new));
    public static final Codec<VillagerTrades.ItemsForEmeralds> SELL_ITEM = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(factory -> ((TradeOffersAccessor.SellItemFactoryAccessor)factory).getSell().m_41720_()), (App)Codec.INT.optionalFieldOf("price", (Object)1).forGetter(factory -> ((TradeOffersAccessor.SellItemFactoryAccessor)factory).getPrice()), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(factory -> ((TradeOffersAccessor.SellItemFactoryAccessor)factory).getCount()), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> ((TradeOffersAccessor.SellItemFactoryAccessor)factory).getMaxUses()), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> ((TradeOffersAccessor.SellItemFactoryAccessor)factory).getExperience())).apply((Applicative)instance, VillagerTrades.ItemsForEmeralds::new));
    public static final Codec<VillagerTrades.SuspiciousStewForEmerald> SELL_SUSPICIOUS_STEW = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256974_.m_194605_().fieldOf("effect").forGetter(factory -> ((TradeOffersAccessor.SellSuspiciousStewFactoryAccessor)factory).getEffect()), (App)Codec.INT.fieldOf("duration").forGetter(factory -> ((TradeOffersAccessor.SellSuspiciousStewFactoryAccessor)factory).getDuration()), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> ((TradeOffersAccessor.SellSuspiciousStewFactoryAccessor)factory).getExperience())).apply((Applicative)instance, VillagerTrades.SuspiciousStewForEmerald::new));
    public static final Codec<VillagerTrades.ItemsAndEmeraldsToItems> PROCESS_ITEM = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(factory -> ((TradeOffersAccessor.ProcessItemFactoryAccessor)factory).getSecondBuy().m_41720_()), (App)Codec.INT.optionalFieldOf("second_count", (Object)1).forGetter(factory -> ((TradeOffersAccessor.ProcessItemFactoryAccessor)factory).getSecondCount()), (App)Codec.INT.optionalFieldOf("price", (Object)1).forGetter(factory -> ((TradeOffersAccessor.ProcessItemFactoryAccessor)factory).getPrice()), (App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("sell_item").forGetter(factory -> ((TradeOffersAccessor.ProcessItemFactoryAccessor)factory).getSell().m_41720_()), (App)Codec.INT.optionalFieldOf("sell_count", (Object)1).forGetter(factory -> ((TradeOffersAccessor.ProcessItemFactoryAccessor)factory).getSellCount()), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> ((TradeOffersAccessor.ProcessItemFactoryAccessor)factory).getMaxUses()), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> ((TradeOffersAccessor.ProcessItemFactoryAccessor)factory).getExperience())).apply((Applicative)instance, VillagerTrades.ItemsAndEmeraldsToItems::new));
    public static final Codec<VillagerTrades.EnchantedItemForEmeralds> SELL_ENCHANTED_TOOL = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(factory -> ((TradeOffersAccessor.SellEnchantedToolFactoryAccessor)factory).getTool().m_41720_()), (App)Codec.INT.optionalFieldOf("base_price", (Object)1).forGetter(factory -> ((TradeOffersAccessor.SellEnchantedToolFactoryAccessor)factory).getBasePrice()), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> ((TradeOffersAccessor.SellEnchantedToolFactoryAccessor)factory).getMaxUses()), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> ((TradeOffersAccessor.SellEnchantedToolFactoryAccessor)factory).getExperience()), (App)Codec.FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(factory -> Float.valueOf(((TradeOffersAccessor.SellEnchantedToolFactoryAccessor)factory).getMultiplier()))).apply((Applicative)instance, VillagerTrades.EnchantedItemForEmeralds::new));
    public static final Codec<VillagerTrades.EmeraldsForVillagerTypeItem> TYPE_AWARE_BUY_FOR_ONE_EMERALD = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(factory -> ((TradeOffersAccessor.TypeAwareBuyForOneEmeraldFactoryAccessor)factory).getCount()), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> ((TradeOffersAccessor.TypeAwareBuyForOneEmeraldFactoryAccessor)factory).getMaxUses()), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> ((TradeOffersAccessor.TypeAwareBuyForOneEmeraldFactoryAccessor)factory).getExperience()), (App)CodecHelper.villagerTypeMap(BuiltInRegistries.f_257033_.m_194605_()).fieldOf("items").forGetter(factory -> ((TradeOffersAccessor.TypeAwareBuyForOneEmeraldFactoryAccessor)factory).getMap())).apply((Applicative)instance, VillagerTrades.EmeraldsForVillagerTypeItem::new));
    public static final Codec<VillagerTrades.TippedArrowForItemsAndEmeralds> SELL_POTION_HOLDING_ITEM = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().optionalFieldOf("arrow", (Object)Items.f_42412_).forGetter(factory -> ((TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor)factory).getSecondBuy()), (App)Codec.INT.optionalFieldOf("second_count", (Object)1).forGetter(factory -> ((TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor)factory).getSecondCount()), (App)BuiltInRegistries.f_257033_.m_194605_().optionalFieldOf("tipped_arrow", (Object)Items.f_42738_).forGetter(factory -> ((TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor)factory).getSell().m_41720_()), (App)Codec.INT.fieldOf("price").forGetter(factory -> ((TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor)factory).getPrice()), (App)Codec.INT.optionalFieldOf("sell_count", (Object)1).forGetter(factory -> ((TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor)factory).getSellCount()), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> ((TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor)factory).getMaxUses()), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> ((TradeOffersAccessor.SellPotionHoldingItemFactoryAccessor)factory).getExperience())).apply((Applicative)instance, VillagerTrades.TippedArrowForItemsAndEmeralds::new));
    public static final Codec<VillagerTrades.EnchantBookForEmeralds> ENCHANT_BOOK = Codec.INT.optionalFieldOf("experience", (Object)2).xmap(VillagerTrades.EnchantBookForEmeralds::new, o -> ((TradeOffersAccessor.EnchantBookFactoryAccessor)o).getExperience()).codec();
    public static final Codec<VillagerTrades.TreasureMapForEmeralds> SELL_MAP = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("price", (Object)1).forGetter(factory -> ((TradeOffersAccessor.SellMapFactoryAccessor)factory).getPrice()), (App)ResourceLocation.f_135803_.fieldOf("feature_tag").xmap(identifier -> TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)identifier), TagKey::f_203868_).forGetter(factory -> ((TradeOffersAccessor.SellMapFactoryAccessor)factory).getStructure()), (App)Codec.STRING.fieldOf("name_key").forGetter(factory -> ((TradeOffersAccessor.SellMapFactoryAccessor)factory).getNameKey()), (App)CodecHelper.forEnum(MapDecoration.Type.class).optionalFieldOf("icon", (Object)MapDecoration.Type.TARGET_X).forGetter(factory -> ((TradeOffersAccessor.SellMapFactoryAccessor)factory).getIconType()), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> ((TradeOffersAccessor.SellMapFactoryAccessor)factory).getMaxUses()), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> ((TradeOffersAccessor.SellMapFactoryAccessor)factory).getExperience())).apply((Applicative)instance, VillagerTrades.TreasureMapForEmeralds::new));
    public static final Codec<VillagerTrades.DyedArmorForEmeralds> SELL_DYED_ARMOR = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(factory -> ((TradeOffersAccessor.SellDyedArmorFactoryAccessor)factory).getSell()), (App)Codec.INT.optionalFieldOf("price", (Object)1).forGetter(factory -> ((TradeOffersAccessor.SellDyedArmorFactoryAccessor)factory).getPrice()), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> ((TradeOffersAccessor.SellDyedArmorFactoryAccessor)factory).getMaxUses()), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> ((TradeOffersAccessor.SellDyedArmorFactoryAccessor)factory).getExperience())).apply((Applicative)instance, VillagerTrades.DyedArmorForEmeralds::new));

    public static Supplier<TradeOfferFactoryType<?>> getVanillaFactoryCodec(VillagerTrades.ItemListing factory) {
        if (factory instanceof VillagerTrades.EmeraldForItems) {
            return TradeOfferFactoryType.BUY_FOR_ONE_EMERALD::get;
        }
        if (factory instanceof VillagerTrades.ItemsForEmeralds) {
            return TradeOfferFactoryType.SELL_ITEM::get;
        }
        if (factory instanceof VillagerTrades.SuspiciousStewForEmerald) {
            return TradeOfferFactoryType.SELL_SUSPICIOUS_STEW::get;
        }
        if (factory instanceof VillagerTrades.ItemsAndEmeraldsToItems) {
            return TradeOfferFactoryType.PROCESS_ITEM::get;
        }
        if (factory instanceof VillagerTrades.EnchantedItemForEmeralds) {
            return TradeOfferFactoryType.SELL_ENCHANTED_TOOL::get;
        }
        if (factory instanceof VillagerTrades.EmeraldsForVillagerTypeItem) {
            return TradeOfferFactoryType.TYPE_AWARE_BUY_FOR_ONE_EMERALD::get;
        }
        if (factory instanceof VillagerTrades.TippedArrowForItemsAndEmeralds) {
            return TradeOfferFactoryType.SELL_POTION_HOLDING_ITEM::get;
        }
        if (factory instanceof VillagerTrades.EnchantBookForEmeralds) {
            return TradeOfferFactoryType.ENCHANT_BOOK::get;
        }
        if (factory instanceof VillagerTrades.TreasureMapForEmeralds) {
            return TradeOfferFactoryType.SELL_MAP::get;
        }
        if (factory instanceof VillagerTrades.DyedArmorForEmeralds) {
            return TradeOfferFactoryType.SELL_DYED_ARMOR::get;
        }
        throw new IllegalStateException("Could not find codec for factory " + factory.getClass());
    }
}

