/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.dynamicvillagertrades.api.CodecHelper;
import io.github.orlouge.dynamicvillagertrades.api.SerializableTradeOfferFactory;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeOfferFactoryType;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.Nullable;

public class TypeAwareSellItemForItemsOfferFactory
implements SerializableTradeOfferFactory {
    public static final Codec<TypeAwareSellItemForItemsOfferFactory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecHelper.villagerTypeMap(CodecHelper.SIMPLE_ITEM_STACK_CODEC).fieldOf("buy_1").forGetter(typeAwareSellItemForItemsOfferFactory -> typeAwareSellItemForItemsOfferFactory.buyMap1), (App)CodecHelper.villagerTypeMap(CodecHelper.SIMPLE_ITEM_STACK_CODEC).optionalFieldOf("buy_2").forGetter(typeAwareSellItemForItemsOfferFactory -> Optional.ofNullable(typeAwareSellItemForItemsOfferFactory.buyMap2)), (App)CodecHelper.villagerTypeMap(CodecHelper.SIMPLE_ITEM_STACK_CODEC).fieldOf("sell").forGetter(typeAwareSellItemForItemsOfferFactory -> typeAwareSellItemForItemsOfferFactory.sellMap), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> factory.maxUses), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> factory.experience)).apply((Applicative)instance, TypeAwareSellItemForItemsOfferFactory::new));
    public final Map<VillagerType, ItemStack> buyMap1;
    public final Map<VillagerType, ItemStack> buyMap2;
    public final Map<VillagerType, ItemStack> sellMap;
    public final int maxUses;
    public final int experience;

    public TypeAwareSellItemForItemsOfferFactory(Map<VillagerType, ItemStack> buyMap1, Optional<Map<VillagerType, ItemStack>> buyMap2, Map<VillagerType, ItemStack> sellMap, int maxUses, int experience) {
        BuiltInRegistries.f_256934_.m_123024_().filter(villagerType -> !buyMap1.containsKey(villagerType) || buyMap2.isPresent() && !((Map)buyMap2.get()).containsKey(villagerType) || !sellMap.containsKey(villagerType)).findAny().ifPresent(villagerType -> {
            throw new IllegalStateException("Missing trade for villager type: " + BuiltInRegistries.f_256934_.m_7981_(villagerType));
        });
        this.buyMap1 = buyMap1;
        this.buyMap2 = buyMap2.orElse(null);
        this.sellMap = sellMap;
        this.maxUses = maxUses;
        this.experience = experience;
    }

    @Nullable
    public MerchantOffer m_213663_(Entity entity, RandomSource random) {
        if (entity instanceof VillagerDataHolder) {
            ItemStack buy1 = this.buyMap1.get(((VillagerDataHolder)entity).m_7141_().m_35560_()).m_41777_();
            ItemStack buy2 = this.buyMap2 != null ? this.buyMap2.get(((VillagerDataHolder)entity).m_7141_().m_35560_()).m_41777_() : ItemStack.f_41583_;
            ItemStack sell = this.sellMap.get(((VillagerDataHolder)entity).m_7141_().m_35560_()).m_41777_();
            return new MerchantOffer(buy1, buy2, sell, this.maxUses, this.experience, 0.05f);
        }
        return null;
    }

    @Override
    public Supplier<TradeOfferFactoryType<?>> getType() {
        return TradeOfferFactoryType.TYPE_AWARE_SELL_ITEMS_FOR_ITEM::get;
    }
}

