/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.dynamicvillagertrades.DynamicVillagerTradesMod;
import io.github.orlouge.dynamicvillagertrades.WeightedRandomList;
import io.github.orlouge.dynamicvillagertrades.trade_offers.ExtendedTradeOffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public record TradeGroup(boolean replace, int minTrades, int maxTrades, double randomness, Optional<Map<String, Double>> affinity, List<ExtendedTradeOffer.Factory> offers, Optional<Map<String, TradeGroup>> subGroups, Optional<String> uniqueKeySet) {
    public static final Codec<TradeGroup> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("replace").forGetter(TradeGroup::replace), (App)Codec.INT.fieldOf("min_trades").forGetter(TradeGroup::minTrades), (App)Codec.INT.fieldOf("max_trades").forGetter(TradeGroup::maxTrades), (App)Codec.DOUBLE.optionalFieldOf("randomness", (Object)1.0).forGetter(TradeGroup::randomness), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).optionalFieldOf("affinity").forGetter(TradeGroup::affinity), (App)ExtendedTradeOffer.Factory.CODEC.listOf().fieldOf("trades").forGetter(TradeGroup::offers), (App)ExtraCodecs.m_184415_(() -> Codec.unboundedMap((Codec)Codec.STRING, CODEC)).optionalFieldOf("subgroups").forGetter(TradeGroup::subGroups), (App)Codec.STRING.optionalFieldOf("unique_key_set").forGetter(TradeGroup::uniqueKeySet)).apply((Applicative)instance, TradeGroup::new));

    public static TradeGroup merge(TradeGroup first, TradeGroup second) {
        if (second.replace) {
            return second;
        }
        HashMap subgroups = new HashMap(first.subGroups.orElse(Collections.emptyMap()));
        second.subGroups().ifPresent(subgroups2 -> subgroups2.forEach((name, group) -> {
            subgroups.computeIfPresent(name, (_name, oldGroup) -> TradeGroup.merge(oldGroup, group));
            subgroups.putIfAbsent(name, group);
        }));
        return new TradeGroup(first.replace, first.minTrades + second.minTrades, first.maxTrades + second.maxTrades, first.randomness * second.randomness, first.affinity, Stream.concat(first.offers.stream(), second.offers.stream()).collect(Collectors.toList()), Optional.of(subgroups), first.uniqueKeySet.or(() -> second.uniqueKeySet));
    }

    public static class SingleTradeOfferSelector
    extends TradeSelector {
        private final ExtendedTradeOffer.Factory offer;
        private final Double weight;
        private boolean invalid;
        private boolean selected = false;

        public SingleTradeOfferSelector(ExtendedTradeOffer.Factory offer, double base_rate, double randomness, int merchantLevel, Map<String, Double> merchantAttributes) {
            this.offer = offer;
            Double[] maxValue = new Double[1];
            offer.affinity().ifPresentOrElse(aff -> {
                maxValue[0] = 1.0;
            }, () -> {
                maxValue[0] = 0.0;
                offer.attributes().forEach((name, value) -> {
                    maxValue[0] = Math.max(maxValue[0], Math.abs(value));
                });
                if (maxValue[0] == 0.0) {
                    maxValue[0] = 1.0;
                }
            });
            this.weight = SingleTradeOfferSelector.weightFunction(merchantAttributes, offer.affinity().orElse(offer.attributes()), maxValue[0], base_rate / randomness);
            this.invalid = offer.level() > merchantLevel;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        @Override
        public List<ExtendedTradeOffer.Factory> getSelectedTrades() {
            return this.selected && !this.invalid ? List.of(this.offer) : Collections.emptyList();
        }

        @Override
        public boolean canSelect() {
            return !this.selected && !this.invalid;
        }

        @Override
        public Optional<String> selectOne(Set<String> excludedKeys) {
            block3: {
                block2: {
                    if (this.invalid) break block2;
                    if (!this.offer.key().map(excludedKeys::contains).orElse(false).booleanValue()) break block3;
                }
                this.selected = false;
                this.invalid = true;
                return null;
            }
            this.selected = true;
            return this.offer.key();
        }
    }

    public static class TradeGroupSelector
    extends TradeSelector {
        private final Collection<TradeSelector> allSelectors;
        private final WeightedRandomList<TradeSelector> randomSelectors = new WeightedRandomList();
        private final int maxTrades;
        private final Optional<Double> weight;
        private final RandomSource random;
        private final Set<String> selectedKeys;
        private static final double base_rate = 0.5;

        public TradeGroupSelector(Collection<TradeSelector> allSelectors, int minTrades, int maxTrades, Optional<Double> weight, int merchantLevel, Map<String, Double> merchantAttributes, RandomSource random, Set<String> selectedKeys) {
            this.allSelectors = allSelectors;
            this.random = random;
            this.weight = weight;
            this.maxTrades = maxTrades;
            this.selectedKeys = selectedKeys;
            allSelectors.forEach(selector -> {
                if (selector.canSelect()) {
                    this.randomSelectors.add(selector.getWeight(), (TradeSelector)selector);
                }
            });
            this.selectN(minTrades);
        }

        public TradeGroupSelector(TradeGroup group, int merchantLevel, Map<String, Double> merchantAttributes, RandomSource random, HashMap<String, HashSet<String>> uniqueKeySets) {
            this(Stream.concat(group.offers().stream().map(offer -> new SingleTradeOfferSelector((ExtendedTradeOffer.Factory)offer, 0.5, group.randomness() * DynamicVillagerTradesMod.GLOBAL_RANDOMNESS, merchantLevel, merchantAttributes)), new TreeMap(group.subGroups().orElse(Collections.emptyMap())).values().stream().map(subgroup -> new TradeGroupSelector((TradeGroup)subgroup, merchantLevel, merchantAttributes, random, uniqueKeySets))).collect(Collectors.toList()), group.minTrades, group.maxTrades, group.affinity().map(affinities -> TradeGroupSelector.weightFunction(merchantAttributes, affinities, 1.0, 0.5)), merchantLevel, merchantAttributes, random, group.uniqueKeySet.map(s -> uniqueKeySets.computeIfAbsent((String)s, s2 -> new HashSet())).orElse(null));
        }

        public TradeGroupSelector(Collection<TradeGroup> groups, Optional<Double> weight, int minTrades, int maxTrades, int merchantLevel, Map<String, Double> merchantAttributes, RandomSource random, HashMap<String, HashSet<String>> uniqueKeySets) {
            this(groups.stream().map(group -> new TradeGroupSelector((TradeGroup)group, merchantLevel, merchantAttributes, random, uniqueKeySets)).collect(Collectors.toList()), minTrades, maxTrades, weight, merchantLevel, merchantAttributes, random, null);
        }

        public TradeGroupSelector(Collection<TradeGroup> groups, int minTrades, int maxTrades, int merchantLevel, Map<String, Double> merchantAttributes, RandomSource random, HashMap<String, HashSet<String>> uniqueKeySets) {
            this(groups, Optional.empty(), minTrades, maxTrades, merchantLevel, merchantAttributes, random, uniqueKeySets);
        }

        @Override
        public double getWeight() {
            return this.weight.orElse(this.randomSelectors.getTotalWeight());
        }

        @Override
        public List<ExtendedTradeOffer.Factory> getSelectedTrades() {
            return this.allSelectors.stream().flatMap(sel -> sel.getSelectedTrades().stream()).collect(Collectors.toList());
        }

        @Override
        public boolean canSelect() {
            return this.randomSelectors.size() > 0 && this.getSelectedTrades().size() < this.maxTrades;
        }

        @Override
        public Optional<String> selectOne(Set<String> excludedKeys) {
            Optional<String> selectedKey = null;
            while (selectedKey == null) {
                TradeSelector selector = this.randomSelectors.popSample(this.random);
                if (selector == null) {
                    return null;
                }
                if (this.selectedKeys != null) {
                    excludedKeys = new HashSet<String>(excludedKeys);
                    excludedKeys.addAll(this.selectedKeys);
                }
                selectedKey = selector.selectOne(excludedKeys);
                if (!selector.canSelect()) continue;
                this.randomSelectors.add(selector.getWeight(), selector);
            }
            if (this.selectedKeys != null && selectedKey.isPresent()) {
                this.selectedKeys.add((String)selectedKey.get());
            }
            return selectedKey;
        }

        private void selectN(int trades) {
            for (int i = 0; this.canSelect() && i < trades; ++i) {
                this.selectOne(Collections.emptySet());
            }
        }
    }

    public static abstract class TradeSelector {
        public abstract double getWeight();

        public abstract List<ExtendedTradeOffer.Factory> getSelectedTrades();

        public abstract boolean canSelect();

        public abstract Optional<String> selectOne(Set<String> var1);

        public Optional<String> selectOne() {
            return this.selectOne(Collections.emptySet());
        }

        public static double weightFunction(Map<String, Double> merchantAttributes, Map<String, Double> affinities, double normalization, double exp) {
            Double[] affinity = new Double[]{0.0};
            affinities.forEach((name, value) -> {
                affinity[0] = affinity[0] + value / normalization * merchantAttributes.getOrDefault(name, 0.0);
            });
            affinity[0] = affinity[0] + 0.0 >= 0.0 ? 1.0 + Math.pow(affinity[0], exp) : 1.0 / Math.pow(-affinity[0].doubleValue(), exp);
            return affinity[0];
        }
    }
}

