/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.dynamicvillagertrades.api.SerializableTradeOfferFactory;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeOfferFactoryType;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class SellSpecificPotionHoldingItemFactory
implements SerializableTradeOfferFactory {
    private final ItemStack sell;
    private final int sellCount;
    private final int price;
    private final int maxUses;
    private final int experience;
    private final Item secondBuy;
    private final int secondCount;
    private final float priceMultiplier;
    private final ResourceLocation potion;
    public static final Codec<SellSpecificPotionHoldingItemFactory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().optionalFieldOf("arrow", (Object)Items.f_42412_).forGetter(factory -> factory.secondBuy), (App)Codec.INT.optionalFieldOf("second_count", (Object)1).forGetter(factory -> factory.secondCount), (App)BuiltInRegistries.f_257033_.m_194605_().optionalFieldOf("tipped_arrow", (Object)Items.f_42738_).forGetter(factory -> factory.sell.m_41720_()), (App)Codec.INT.fieldOf("price").forGetter(factory -> factory.price), (App)Codec.INT.optionalFieldOf("sell_count", (Object)1).forGetter(factory -> factory.sellCount), (App)Codec.INT.optionalFieldOf("max_uses", (Object)12).forGetter(factory -> factory.maxUses), (App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(factory -> factory.experience), (App)ResourceLocation.f_135803_.fieldOf("potion").forGetter(SellSpecificPotionHoldingItemFactory::getPotion)).apply((Applicative)instance, SellSpecificPotionHoldingItemFactory::new));

    public SellSpecificPotionHoldingItemFactory(Item secondBuy, int secondCount, Item sellItem, int sellCount, int price, int maxUses, int experience, ResourceLocation potion) {
        this.sell = new ItemStack((ItemLike)sellItem);
        this.price = price;
        this.maxUses = maxUses;
        this.experience = experience;
        this.secondBuy = secondBuy;
        this.secondCount = secondCount;
        this.sellCount = sellCount;
        this.potion = potion;
        this.priceMultiplier = 0.05f;
    }

    public ResourceLocation getPotion() {
        return this.potion;
    }

    public MerchantOffer m_213663_(Entity entity, RandomSource random) {
        Optional optPotion = BuiltInRegistries.f_256980_.m_6612_(this.potion);
        if (optPotion.isEmpty()) {
            throw new IllegalStateException("Potion " + this.potion + " does not exist.");
        }
        ItemStack emerald = new ItemStack((ItemLike)Items.f_42616_, this.price);
        ItemStack sellItem = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.sell.m_41720_(), this.sellCount), (Potion)((Potion)optPotion.get()));
        return new MerchantOffer(emerald, new ItemStack((ItemLike)this.secondBuy, this.secondCount), sellItem, this.maxUses, this.experience, this.priceMultiplier);
    }

    @Override
    public Supplier<TradeOfferFactoryType<?>> getType() {
        return TradeOfferFactoryType.SELL_SPECIFIC_POTION_HOLDING_ITEM::get;
    }
}

