/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.dynamicvillagertrades.TradeOfferManager;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeOfferFactoryType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;

public class ExtendedTradeOffer
extends MerchantOffer {
    public final Map<String, Double> attributeIncrement;
    private final boolean writeCache;
    private static final String attribute_key = "dynamicvillagertrades_attributes";
    private static final String write_cache_key = "dynamicvillagertrades_write_cache";

    public ExtendedTradeOffer(CompoundTag nbt) {
        this(nbt, nbt.m_128441_(write_cache_key) && nbt.m_128471_(write_cache_key));
    }

    public ExtendedTradeOffer(CompoundTag nbt, boolean writeCache) {
        super(nbt);
        this.attributeIncrement = new HashMap<String, Double>();
        this.writeCache = writeCache;
        if (nbt.m_128441_(attribute_key)) {
            CompoundTag nbta = nbt.m_128469_(attribute_key);
            nbta.m_128431_().forEach(attr -> this.attributeIncrement.put((String)attr, nbta.m_128459_(attr)));
        }
    }

    public ExtendedTradeOffer(MerchantOffer offer, Map<String, Double> attributes, boolean writeCache) {
        super(offer.m_45352_(), offer.m_45364_(), offer.m_45368_(), offer.m_45371_(), offer.m_45373_(), offer.m_45379_(), offer.m_45378_(), offer.m_45375_());
        this.attributeIncrement = attributes;
        this.writeCache = writeCache;
    }

    public CompoundTag m_45384_() {
        CompoundTag base = super.m_45384_();
        CompoundTag nbta = new CompoundTag();
        this.attributeIncrement.forEach((arg_0, arg_1) -> ((CompoundTag)nbta).m_128347_(arg_0, arg_1));
        base.m_128365_(attribute_key, (Tag)nbta);
        base.m_128379_(write_cache_key, this.writeCache);
        return base;
    }

    public Optional<CompoundTag> extraNbt() {
        if (this.writeCache) {
            CompoundTag base = new CompoundTag();
            base.m_128365_("cached_offer", (Tag)this.m_45384_());
            return Optional.of(base);
        }
        return Optional.empty();
    }

    public record Factory(VillagerTrades.ItemListing offer, Integer level, Map<String, Double> attributes, Optional<Map<String, Double>> affinity, Optional<String> key, Boolean cache) {
        public static final Codec<Factory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TradeOfferFactoryType.CODEC.fieldOf("offer").forGetter(Factory::offer), (App)StringRepresentable.m_216439_(TradeOfferManager.MerchantLevel::values).flatComapMap(TradeOfferManager.MerchantLevel::getId, TradeOfferManager.MerchantLevel::fromId).fieldOf("level").forGetter(Factory::level), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).fieldOf("attributes").forGetter(Factory::attributes), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).optionalFieldOf("affinity").forGetter(Factory::affinity), (App)Codec.STRING.optionalFieldOf("key").forGetter(Factory::key), (App)Codec.BOOL.optionalFieldOf("cache", (Object)false).forGetter(Factory::cache)).apply((Applicative)instance, Factory::new));
        public static final String cached_offer_key = "cached_offer";

        public ExtendedTradeOffer create(Entity entity, RandomSource random, Optional<CompoundTag> data) {
            if (this.cache.booleanValue() && this.key.isPresent() && data.map(d -> d.m_128441_(cached_offer_key)).orElse(false).booleanValue()) {
                return new ExtendedTradeOffer(data.get().m_128469_(cached_offer_key), this.cache);
            }
            MerchantOffer offer = this.offer.m_213663_(entity, random);
            return offer == null ? null : new ExtendedTradeOffer(offer, this.attributes, this.cache);
        }

        @Override
        public String toString() {
            return this.offer.toString();
        }
    }
}

