/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.trade_offers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.dynamicvillagertrades.DynamicVillagerTradesMod;
import io.github.orlouge.dynamicvillagertrades.api.SerializableTradeOfferFactory;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeOfferFactoryType;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EnchantSpecificBookFactory
implements SerializableTradeOfferFactory {
    private final int experience;
    private final ResourceLocation type;
    private final int level;
    public static final Codec<EnchantSpecificBookFactory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("experience", (Object)2).forGetter(EnchantSpecificBookFactory::getExperience), (App)ResourceLocation.f_135803_.fieldOf("enchantment").forGetter(EnchantSpecificBookFactory::getEnchantmentType), (App)Codec.INT.optionalFieldOf("level", (Object)1).forGetter(EnchantSpecificBookFactory::getLevel)).apply((Applicative)instance, EnchantSpecificBookFactory::new));

    public EnchantSpecificBookFactory(int experience, ResourceLocation type, int level) {
        this.experience = experience;
        this.type = type;
        this.level = level;
    }

    @Override
    public Supplier<TradeOfferFactoryType<?>> getType() {
        return TradeOfferFactoryType.ENCHANT_SPECIFIC_BOOK::get;
    }

    @Nullable
    public MerchantOffer m_213663_(Entity entity, RandomSource random) {
        Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(this.type);
        if (enchantment == null) {
            throw new IllegalStateException("Enchantment " + this.type + " does not exist.");
        }
        ItemStack itemStack = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, this.level));
        if (DynamicVillagerTradesMod.ENCHANT_REPAIR_COMPAT) {
            EnchantedBookItem.m_41153_((ItemStack)itemStack, (EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44963_, 1));
        }
        int j = 2 + random.m_188503_(5 + this.level * 10) + 3 * this.level;
        if (enchantment.m_6591_()) {
            j *= 2;
        }
        if (j > 64) {
            j = 64;
        }
        return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, j), new ItemStack((ItemLike)Items.f_42517_), itemStack, 12, this.experience, 0.2f);
    }

    public int getExperience() {
        return this.experience;
    }

    public ResourceLocation getEnchantmentType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return this.type.toString() + ":" + this.level;
    }
}

