/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.mixin;

import io.github.orlouge.dynamicvillagertrades.DynamicVillagerTradesMod;
import io.github.orlouge.dynamicvillagertrades.ExtendedVillagerEntity;
import io.github.orlouge.dynamicvillagertrades.trade_offers.ExtendedTradeOffer;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerEntityMixin
extends AbstractVillager
implements ExtendedVillagerEntity {
    private int dvtRestockCount = 0;
    private final Map<String, Double> attributes = new HashMap<String, Double>();
    private final Map<String, CompoundTag> extra_offer_data = new HashMap<String, CompoundTag>();
    private static final String attributes_key = "dynamicvillagertrades_attributes";
    private static final String extra_offer_data_key = "dynamicvillagertrades_extra_offer_data";

    @Shadow
    public abstract VillagerData m_7141_();

    @Shadow
    public abstract void m_6703_(@Nullable LivingEntity var1);

    public VillagerEntityMixin(EntityType<? extends AbstractVillager> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void loadAttributes(CompoundTag nbt, CallbackInfo info) {
        this.readExtraData(nbt);
    }

    private void readAttributes(CompoundTag nbt) {
        nbt.m_128431_().forEach(attr -> this.attributes.put((String)attr, nbt.m_128459_(attr)));
    }

    private void readExtraOfferData(CompoundTag nbt) {
        this.extra_offer_data.clear();
        CompoundTag data_map = nbt.m_128469_(extra_offer_data_key);
        data_map.m_128431_().forEach(key -> this.extra_offer_data.put((String)key, data_map.m_128469_(key)));
    }

    @Override
    public void readExtraData(CompoundTag nbt) {
        if (nbt.m_128441_(attributes_key)) {
            this.readAttributes(nbt.m_128469_(attributes_key));
            if (nbt.m_128425_("Offers", 10)) {
                this.loadExtendedOffers(nbt.m_128469_("Offers"));
            }
        }
        if (nbt.m_128441_(extra_offer_data_key)) {
            this.readExtraOfferData(nbt);
        }
    }

    @Override
    public void writeExtraData(CompoundTag nbt) {
        CompoundTag nbta = new CompoundTag();
        this.attributes.forEach((arg_0, arg_1) -> ((CompoundTag)nbta).m_128347_(arg_0, arg_1));
        nbt.m_128365_(attributes_key, (Tag)nbta);
        CompoundTag nbteod = new CompoundTag();
        this.extra_offer_data.forEach((arg_0, arg_1) -> ((CompoundTag)nbteod).m_128365_(arg_0, arg_1));
        nbt.m_128365_(extra_offer_data_key, (Tag)nbteod);
    }

    private void loadExtendedOffers(CompoundTag offers) {
        ListTag recipes = offers.m_128437_("Recipes", 10);
        MerchantOffers tradeOffers = new MerchantOffers();
        for (int i = 0; i < recipes.size(); ++i) {
            tradeOffers.add((Object)new ExtendedTradeOffer(recipes.m_128728_(i)));
        }
        this.f_35261_ = tradeOffers;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void saveAttributes(CompoundTag nbt, CallbackInfo info) {
        this.writeExtraData(nbt);
    }

    @Inject(method={"fillRecipes"}, at={@At(value="HEAD")}, cancellable=true)
    private void refreshOnLevelUp(CallbackInfo ci) {
        if (this.refreshOffers()) {
            ci.cancel();
        }
    }

    @Inject(method={"restock"}, at={@At(value="HEAD")})
    private void refreshOnRestock(CallbackInfo ci) {
        if (this.dvtRestockCount >= DynamicVillagerTradesMod.REFRESH_DELAY) {
            this.refreshOffers();
            this.dvtRestockCount = 0;
        } else {
            ++this.dvtRestockCount;
        }
    }

    @Inject(method={"restockAndUpdateDemandBonus"}, at={@At(value="HEAD")})
    private void refreshOnRestockAndUpdateDemandBonus(CallbackInfo ci) {
        this.refreshOffers();
    }

    @Inject(method={"afterUsing"}, at={@At(value="HEAD")})
    private void updateAttributesAfterUse(MerchantOffer offer, CallbackInfo ci) {
        if (offer instanceof ExtendedTradeOffer) {
            ExtendedTradeOffer extOffer = (ExtendedTradeOffer)offer;
            extOffer.attributeIncrement.forEach((attr, increment) -> this.attributes.put((String)attr, increment + this.attributes.getOrDefault(attr, 0.0)));
        }
    }

    private boolean refreshOffers() {
        Optional<Collection> optoffers = DynamicVillagerTradesMod.TRADE_OFFER_MANAGER.getVillagerOffers(this.m_7141_().m_35571_()).map(Map::values);
        optoffers.ifPresent(offerGroups -> {
            MerchantOffers offerList = this.m_6616_();
            offerList.clear();
            int level = this.m_7141_().m_35576_();
            TradeGroup.TradeGroupSelector selector = new TradeGroup.TradeGroupSelector((Collection<TradeGroup>)offerGroups, level * 2, level * 2, level, this.attributes, this.f_19796_, new HashMap<String, HashSet<String>>());
            HashMap new_data = new HashMap();
            selector.getSelectedTrades().forEach(tradeFactory -> {
                ExtendedTradeOffer generatedOffer = tradeFactory.create((Entity)this, this.f_19796_, tradeFactory.key().flatMap(key -> Optional.ofNullable(this.extra_offer_data.get(key))));
                if (generatedOffer != null) {
                    offerList.add((Object)generatedOffer);
                    tradeFactory.key().ifPresent(key -> generatedOffer.extraNbt().ifPresent(data -> new_data.put(key, data)));
                }
            });
            this.extra_offer_data.clear();
            this.extra_offer_data.putAll(new_data);
        });
        return optoffers.isPresent();
    }
}

