/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades.forge;

import com.mojang.serialization.Codec;
import io.github.orlouge.dynamicvillagertrades.PlatformHelper;
import io.github.orlouge.dynamicvillagertrades.TradeOfferManager;
import io.github.orlouge.dynamicvillagertrades.forge.DynamicVillagerTradesModForge;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeOfferFactoryType;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;

public class PlatformHelperImpl {
    public static final TradeOfferManager tradeOfferManager = new TradeOfferManager();
    public static final RegistryHelperForge<TradeOfferFactoryType<?>> tradeOfferFactoryTypeRegistryHelper = new RegistryHelperForge(() -> DynamicVillagerTradesModForge.supplier.get());

    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static boolean isModLoaded(String id) {
        return ModList.get().isLoaded(id);
    }

    public static PlatformHelper.RegistryHelper<TradeOfferFactoryType<?>> getTradeOfferRegistry() {
        return tradeOfferFactoryTypeRegistryHelper;
    }

    public static TradeOfferManager getTradeOfferManager() {
        return tradeOfferManager;
    }

    public static class RegistryHelperForge<T>
    implements PlatformHelper.RegistryHelper<T> {
        private boolean registered = false;
        private final Supplier<IForgeRegistry<T>> registry;
        private final Map<ResourceLocation, Supplier<? extends T>> entries = new LinkedHashMap<ResourceLocation, Supplier<? extends T>>();

        private RegistryHelperForge(Supplier<IForgeRegistry<T>> registry) {
            this.registry = registry;
        }

        @Override
        public Supplier<Codec<T>> getCodec() {
            return () -> this.registry.get().getCodec();
        }

        public void registerAll(RegisterEvent event) {
            ResourceKey registryKey = this.registry.get().getRegistryKey();
            DynamicVillagerTradesModForge.LOGGER.log(Level.INFO, event.getRegistryKey() + "_" + registryKey.toString());
            if (event.getRegistryKey().equals((Object)registryKey)) {
                this.registered = true;
                DynamicVillagerTradesModForge.LOGGER.log(Level.INFO, event.getRegistryKey() + "_" + registryKey);
                for (Map.Entry e : this.entries.entrySet()) {
                    event.register(registryKey, e.getKey(), () -> ((Supplier)e.getValue()).get());
                    DynamicVillagerTradesModForge.LOGGER.log(Level.INFO, e.getKey().toString());
                }
                this.entries.clear();
            }
        }

        @Override
        public <V extends T> Supplier<V> register(ResourceLocation name, Supplier<V> entry) {
            DynamicVillagerTradesModForge.LOGGER.log(Level.INFO, "register " + name.toString());
            if (this.registered) {
                this.registry.get().register(name, entry.get());
            } else {
                this.entries.put(name, entry);
            }
            return () -> this.registry.get().getValue(name);
        }
    }
}

