/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.dynamicvillagertrades.DynamicVillagerTradesMod;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeGroup;
import io.github.orlouge.dynamicvillagertrades.trade_offers.generators.Generator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;

public class TradeOfferManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ResourceLocation WANDERING_TRADER_PROFESSION_ID = BuiltInRegistries.f_256780_.m_7981_((Object)EntityType.f_20494_);
    public static final ResourceLocation ID = DynamicVillagerTradesMod.id("trade_offers");
    private Map<ResourceLocation, Map<String, TradeGroup>> tradeGroups = Map.of();

    public TradeOfferManager() {
        super(GSON, ID.m_135815_());
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, Map<String, TradeGroup>> builderMap = new HashMap<ResourceLocation, Map<String, TradeGroup>>();
        AtomicInteger loadedCount = new AtomicInteger();
        manager.m_214159_(ID.m_135815_(), id -> id.m_135815_().endsWith(".json")).forEach((id, res) -> {
            ResourceLocation identifier = new ResourceLocation(id.m_135827_(), id.m_135815_().substring(ID.m_135815_().length() + 1, id.m_135815_().length() - 5));
            JsonElement jsonElement = (JsonElement)prepared.get(identifier);
            if (jsonElement != null) {
                VillagerTrades trades = (VillagerTrades)((Pair)VillagerTrades.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, s -> {})).getFirst();
                builderMap.computeIfAbsent(trades.profession, p -> this.generateTradeGroups((VillagerProfession)BuiltInRegistries.f_256735_.m_7745_(p)).orElse(new TreeMap()));
                if (trades.replace) {
                    builderMap.put(trades.profession, new TreeMap());
                }
                Map groups = (Map)builderMap.get(trades.profession);
                trades.offers().forEach((name, group) -> {
                    groups.computeIfPresent(name, (_name, oldGroup) -> TradeGroup.merge(oldGroup, group));
                    groups.putIfAbsent(name, group);
                });
                loadedCount.incrementAndGet();
            }
        });
        this.tradeGroups = builderMap;
        Generator.resetAll();
    }

    public Optional<Map<String, TradeGroup>> getVillagerOffers(VillagerProfession profession) {
        return Optional.ofNullable(this.tradeGroups.get(BuiltInRegistries.f_256735_.m_7981_((Object)profession))).or(() -> this.generateTradeGroups(profession));
    }

    private Optional<Map<String, TradeGroup>> generateTradeGroups(VillagerProfession profession) {
        return Generator.generateAll(profession);
    }

    public record VillagerTrades(ResourceLocation profession, boolean replace, Map<String, TradeGroup> offers) {
        public static final Codec<VillagerTrades> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("profession").forGetter(VillagerTrades::profession), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(VillagerTrades::replace), (App)Codec.unboundedMap((Codec)Codec.STRING, TradeGroup.CODEC).fieldOf("offers").forGetter(VillagerTrades::offers)).apply((Applicative)instance, VillagerTrades::new));
    }

    public static enum MerchantLevel implements StringRepresentable
    {
        NOVICE("novice", 1),
        APPRENTICE("apprentice", 2),
        JOURNEYMAN("journeyman", 3),
        EXPERT("expert", 4),
        MASTER("master", 5),
        COMMON("common", 1),
        RARE("rare", 2);

        public final String name;
        public final int id;

        private MerchantLevel(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static DataResult<MerchantLevel> fromId(int id) {
            for (MerchantLevel value : MerchantLevel.values()) {
                if (value.id != id) continue;
                return DataResult.success((Object)((Object)value));
            }
            return DataResult.error(() -> "Invalid level index " + id + " provided.");
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

