/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.orlouge.dynamicvillagertrades.PlatformHelper;
import io.github.orlouge.dynamicvillagertrades.TradeOfferManager;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeGroup;
import io.github.orlouge.dynamicvillagertrades.trade_offers.TradeOfferFactoryType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;

public class DynamicVillagerTradesMod {
    public static final String MOD_ID = "dynamicvillagertrades";
    public static boolean NO_BOOK_DUPLICATES = true;
    public static boolean ENCHANT_REPAIR_COMPAT = PlatformHelper.isModLoaded("enchantrepair");
    public static double GLOBAL_RANDOMNESS = 1.0;
    public static int REFRESH_DELAY = 0;
    public static final String CONFIG_FNAME = PlatformHelper.getConfigDirectory() + "/dynamicvillagertrades.properties";
    public static final TradeOfferManager TRADE_OFFER_MANAGER = PlatformHelper.getTradeOfferManager();

    public static void init() {
        TradeOfferFactoryType.init();
        Properties defaultProps = new Properties();
        defaultProps.setProperty("no_book_duplicates", Boolean.toString(NO_BOOK_DUPLICATES));
        defaultProps.setProperty("global_randomness", Double.toString(GLOBAL_RANDOMNESS));
        defaultProps.setProperty("refresh_delay", Integer.toString(REFRESH_DELAY));
        defaultProps.setProperty("enchant_repair_compat", Boolean.toString(ENCHANT_REPAIR_COMPAT));
        File f = new File(CONFIG_FNAME);
        if (f.isFile() && f.canRead()) {
            try (FileInputStream in = new FileInputStream(f);){
                Properties props = new Properties(defaultProps);
                props.load(in);
                NO_BOOK_DUPLICATES = Boolean.parseBoolean(props.getProperty("no_book_duplicates"));
                GLOBAL_RANDOMNESS = Double.parseDouble(props.getProperty("global_randomness"));
                REFRESH_DELAY = Integer.parseInt(props.getProperty("refresh_delay"));
                ENCHANT_REPAIR_COMPAT = Boolean.parseBoolean(props.getProperty("enchant_repair_compat"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try (FileOutputStream out = new FileOutputStream(CONFIG_FNAME);){
                defaultProps.store(out, "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ResourceLocation id(String string) {
        return new ResourceLocation(MOD_ID, string);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder baseCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)MOD_ID).requires(source -> source.m_6761_(2));
        baseCommand.then(Commands.m_82127_((String)"export").executes(context -> {
            DynamicVillagerTradesMod.exportDatapack(err -> ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)err.getMessage()), false), path -> ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Exported to " + path)), false));
            return 1;
        }));
        dispatcher.register(baseCommand);
    }

    public static void exportDatapack(Consumer<Exception> onException, Consumer<String> onExport) {
        File zipFile = new File("dvt_generated_pack.zip");
        boolean exported = false;
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        try {
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipFile));
            int packVersion = 15;
            zip.putNextEntry(new ZipEntry("pack.mcmeta"));
            byte[] metadata_json = ("{\"pack\":{\"description\":\"Generated datapack\",\"pack_format\":" + packVersion + "}}").getBytes();
            zip.write(metadata_json, 0, metadata_json.length);
            zip.closeEntry();
            BuiltInRegistries.f_256735_.m_6579_().forEach(professionEntry -> {
                ResourceLocation professionId = ((ResourceKey)professionEntry.getKey()).m_135782_();
                VillagerProfession profession = (VillagerProfession)professionEntry.getValue();
                Optional<Map<String, TradeGroup>> tradeGroups = TRADE_OFFER_MANAGER.getVillagerOffers(profession);
                if (tradeGroups.isPresent()) {
                    try {
                        TradeOfferManager.VillagerTrades trades = new TradeOfferManager.VillagerTrades(professionId, true, tradeGroups.get());
                        byte[] json = TradeOfferManager.GSON.toJson((JsonElement)TradeOfferManager.VillagerTrades.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)trades).getOrThrow(false, s -> {
                            throw new RuntimeException((String)s);
                        })).getBytes();
                        zip.putNextEntry(new ZipEntry("data/dynamicvillagertrades/" + TradeOfferManager.ID.m_135815_() + "/" + professionId.m_135815_() + ".json"));
                        zip.write(json, 0, json.length);
                        zip.closeEntry();
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            });
            zip.close();
            exported = true;
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        for (Exception e : exceptions) {
            onException.accept(e);
        }
        if (exported) {
            onExport.accept(zipFile.getAbsolutePath());
        }
    }
}

