/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.dynamicvillagertrades;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.BaseMapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public record DefaultMapCodec<K, V>(Codec<K> keyCodec, Codec<V> valueCodec, Keyable requiredKeys) implements BaseMapCodec<K, V>,
Codec<Map<K, V>>
{
    private static final String DEFAULT_VALUE_KEY = "default";

    public static <K, V> DefaultMapCodec<K, V> of(Codec<K> keyCodec, Codec<V> valueCodec, Keyable requiredKeys) {
        return new DefaultMapCodec<K, V>(keyCodec, valueCodec, requiredKeys);
    }

    public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        AtomicReference<DataResult> result = new AtomicReference<DataResult>(DataResult.success(new HashMap()));
        this.requiredKeys.keys(ops).forEach(key -> {
            DataResult<V> value = this.getOrDefault(input, key, ops);
            value.error().ifPresent(vPartialResult -> {
                if (((DataResult)result.get()).error().isEmpty()) {
                    result.set(((DataResult)result.get()).flatMap(kvMap -> DataResult.error(() -> "", (Object)kvMap)));
                }
                result.set(((DataResult)result.get()).mapError(s -> s + " " + vPartialResult.message()));
            });
            value.result().ifPresent(v -> ((DataResult)result.get()).map(kvMap -> {
                kvMap.put(this.keyCodec().parse(ops, key).result().orElseThrow(), v);
                return kvMap;
            }));
        });
        return result.get();
    }

    private <T> DataResult<V> getOrDefault(MapLike<T> input, T key, DynamicOps<T> ops) {
        Object encodedValue = input.get(key);
        if (encodedValue == null) {
            Object encodedDefaultValue = input.get(DEFAULT_VALUE_KEY);
            if (encodedDefaultValue == null) {
                return DataResult.error(() -> "Missing value for key " + key + " and no default defined");
            }
            return this.elementCodec().decode(ops, encodedDefaultValue).map(Pair::getFirst);
        }
        return this.elementCodec().decode(ops, encodedValue).map(Pair::getFirst);
    }

    public Codec<V> elementCodec() {
        return this.valueCodec;
    }

    public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
        return this.encode(input, ops, ops.mapBuilder()).build(prefix);
    }

    public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).flatMap(map -> this.decode(ops, (Object)map)).map(r -> Pair.of((Object)r, (Object)input));
    }
}

