/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.util;

import com.github.jarva.arsadditions.common.block.tile.SourceSpawnerTile;
import com.github.jarva.arsadditions.common.recipe.SourceSpawnerRecipe;
import com.github.jarva.arsadditions.common.util.AddonSourceUtil;
import com.github.jarva.arsadditions.common.util.codec.TagModifier;
import com.github.jarva.arsadditions.datagen.tags.EntityTypeTagDatagen;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.ModifyTagRegistry;
import com.github.jarva.arsadditions.setup.registry.recipes.SourceSpawnerRegistry;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SourceSpawner
extends BaseSpawner {
    private final BlockEntity blockEntity;
    public boolean disabled = false;
    public WeightedRandomList<WeightedEntry.Wrapper<SpawnData>> spawnPotentials = WeightedRandomList.m_146332_();
    public HashMap<EntityType<?>, SourceSpawnerRecipe> recipes = new HashMap();
    public short spawnDelay = (short)20;
    public short minSpawnDelay = (short)200;
    public short maxSpawnDelay = (short)800;
    public short spawnCount = (short)4;
    public short maxNearbyEntities = (short)6;
    public short requiredPlayerRange = (short)16;
    public short spawnRange = (short)4;
    private static final ModifyTagRegistry.AppendTag APPEND_SOURCE_SPAWNER_TAG = new ModifyTagRegistry.AppendTag(Map.of("Tags", StringTag.m_129297_((String)"ars_additions:source_spawner")));

    public SourceSpawner(SourceSpawnerTile sourceSpawnerTile) {
        this.blockEntity = sourceSpawnerTile;
    }

    public void m_151328_(@Nullable Level level, BlockPos pos, CompoundTag tag) {
        this.spawnDelay = tag.m_128448_("Delay");
        if (tag.m_128425_("MinSpawnDelay", 99)) {
            this.minSpawnDelay = tag.m_128448_("MinSpawnDelay");
            this.maxSpawnDelay = tag.m_128448_("MaxSpawnDelay");
            this.spawnCount = tag.m_128448_("SpawnCount");
        }
        if (tag.m_128425_("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = tag.m_128448_("MaxNearbyEntities");
            this.requiredPlayerRange = tag.m_128448_("RequiredPlayerRange");
        }
        if (tag.m_128425_("SpawnRange", 99)) {
            this.spawnRange = tag.m_128448_("SpawnRange");
        }
        this.disabled = tag.m_128471_("Disabled");
    }

    public CompoundTag m_186381_(CompoundTag tag) {
        tag.m_128376_("Delay", this.spawnDelay);
        tag.m_128376_("MinSpawnDelay", this.minSpawnDelay);
        tag.m_128376_("MaxSpawnDelay", this.maxSpawnDelay);
        tag.m_128376_("SpawnCount", this.spawnCount);
        tag.m_128376_("MaxNearbyEntities", this.maxNearbyEntities);
        tag.m_128376_("RequiredPlayerRange", this.requiredPlayerRange);
        tag.m_128376_("SpawnRange", this.spawnRange);
        tag.m_128379_("Disabled", this.disabled);
        return tag;
    }

    public void m_142523_(Level level, BlockPos pos, int eventId) {
        level.m_7696_(pos, (Block)AddonBlockRegistry.SOURCE_SPAWNER.get(), eventId, 0);
    }

    private void delay(Level level, BlockPos pos) {
        RandomSource randomSource = level.m_213780_();
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : (short)(this.minSpawnDelay + randomSource.m_188503_(this.maxSpawnDelay - this.minSpawnDelay));
    }

    private SimpleWeightedRandomList<SpawnData> getEntities(ServerLevel level, BlockPos pos) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        for (BlockPos b : BlockPos.m_121925_((BlockPos)pos, (int)10, (int)10, (int)10)) {
            LivingEntity livingEntity;
            EntityType type;
            MobJarTile mobJarTile;
            BlockEntity blockEntity = level.m_7702_(b);
            if (!(blockEntity instanceof MobJarTile) || !((blockEntity = (mobJarTile = (MobJarTile)blockEntity).getEntity()) instanceof LivingEntity) || (type = (livingEntity = (LivingEntity)blockEntity).m_6095_()).m_204039_(EntityTypeTagDatagen.SOURCE_SPAWNER_DENYLIST)) continue;
            CompoundTag entityTag = new CompoundTag();
            entityTag.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_((Object)type).toString());
            this.getRecipe((Entity)livingEntity).ifPresent(recipe -> {
                this.recipes.put((EntityType<?>)type, (SourceSpawnerRecipe)recipe);
                recipe.tag_modifiers().ifPresent(modifiers -> {
                    livingEntity.m_20086_(entityTag);
                    for (TagModifier modifier : modifiers) {
                        modifier.modify(entityTag);
                    }
                });
            });
            entityTag.m_128473_("UUID");
            APPEND_SOURCE_SPAWNER_TAG.modify(entityTag);
            builder.m_146271_((Object)new SpawnData(entityTag, Optional.empty()), 1);
        }
        return builder.m_146270_();
    }

    public void removeEntry(WeightedEntry.Wrapper<SpawnData> entry) {
        ArrayList potentials = new ArrayList(this.spawnPotentials.m_146338_());
        potentials.remove(entry);
        this.spawnPotentials = WeightedRandomList.m_146328_(potentials);
    }

    public Optional<SourceSpawnerRecipe> getRecipe(Entity entity) {
        return SourceSpawnerRegistry.INSTANCE.getRecipes().stream().filter(r -> r.isMatch(entity.m_6095_())).findFirst();
    }

    public int calculateSource(Entity entity) {
        EntityType type = entity.m_6095_();
        SourceSpawnerRecipe recipe = this.recipes.get(type);
        if (recipe != null && recipe.source().isPresent()) {
            return recipe.source().get();
        }
        int source = 200;
        if (type.m_204039_(EntityTypeTagDatagen.BOSSES)) {
            source += 10000;
        }
        if (type.m_20674_().m_21610_()) {
            source += 1000;
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            source += (int)(mob.m_21233_() * 50.0f);
        }
        return source;
    }

    public void m_151311_(ServerLevel level, BlockPos pos) {
        if (!this.isNearPlayer((Level)level, pos)) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.delay((Level)level, pos);
            return;
        }
        if (this.spawnDelay > 0) {
            this.spawnDelay = (short)(this.spawnDelay - 1);
            return;
        }
        if (this.disabled) {
            return;
        }
        this.spawnPotentials = this.getEntities(level, pos);
        if (this.spawnPotentials.m_146337_()) {
            this.delay((Level)level, pos);
            return;
        }
        RandomSource randomSource = level.m_213780_();
        int count = this.spawnCount;
        while (count > 0) {
            double z;
            double y;
            double x;
            int total = this.spawnPotentials.m_146338_().size();
            if (total == 0) {
                this.delay((Level)level, pos);
                return;
            }
            WeightedEntry.Wrapper wrappedSpawnData = this.spawnPotentials.m_216829_(randomSource).orElse(null);
            if (wrappedSpawnData == null) {
                this.delay((Level)level, pos);
                return;
            }
            SpawnData spawnData = (SpawnData)wrappedSpawnData.m_146310_();
            CompoundTag entityTag = spawnData.m_186567_();
            Optional entityTypeOptional = EntityType.m_20637_((CompoundTag)entityTag);
            if (entityTypeOptional.isEmpty()) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            EntityType entityType = (EntityType)entityTypeOptional.get();
            if (!level.m_45772_(entityType.m_20585_(x = (double)pos.m_123341_() + (randomSource.m_188500_() - randomSource.m_188500_()) * (double)this.spawnRange + 0.5, y = (double)(pos.m_123342_() + randomSource.m_188503_(3) - 1), z = (double)pos.m_123343_() + (randomSource.m_188500_() - randomSource.m_188500_()) * (double)this.spawnRange + 0.5))) continue;
            if (!entityType.m_20674_().m_21609_() && level.m_46791_() == Difficulty.PEACEFUL) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            Entity entity = EntityType.m_20645_((CompoundTag)entityTag, (Level)level, arg -> {
                arg.m_7678_(x, y, z, arg.m_146908_(), arg.m_146909_());
                return arg;
            });
            if (entity == null) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            int nearby = level.m_45976_(entity.getClass(), new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_82400_((double)this.spawnRange)).size();
            if (nearby >= this.maxNearbyEntities) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), randomSource.m_188501_() * 360.0f, 0.0f);
            if (!level.m_8860_(entity)) {
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            int neededSource = this.calculateSource(entity);
            boolean tookSource = AddonSourceUtil.takeSource(pos, (Level)level, 5, neededSource);
            if (!tookSource) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                this.removeEntry((WeightedEntry.Wrapper<SpawnData>)wrappedSpawnData);
                continue;
            }
            level.m_46796_(2004, pos, 0);
            level.m_142346_(entity, GameEvent.f_157810_, pos);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_21373_();
            }
            --count;
        }
        if (count < this.spawnCount) {
            this.delay((Level)level, pos);
        }
    }

    private boolean isNearPlayer(Level level, BlockPos pos) {
        return level.m_45914_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)this.requiredPlayerRange);
    }

    public void m_151319_(Level level, BlockPos pos) {
        if (this.isNearPlayer(level, pos) && !this.disabled) {
            RandomSource randomSource = level.m_213780_();
            double x = (double)pos.m_123341_() + randomSource.m_188500_();
            double y = (double)pos.m_123342_() + randomSource.m_188500_();
            double z = (double)pos.m_123343_() + randomSource.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                this.spawnDelay = (short)(this.spawnDelay - 1);
            }
        }
    }

    @Nullable
    public BlockEntity getSpawnerBlockEntity() {
        return this.blockEntity;
    }
}

