/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.data;

import com.davigj.blasted_barrens.core.registry.BBBlocks;
import com.dolthhaven.dolt_mod_how.core.registry.DMHBlocks;
import com.google.common.collect.ImmutableList;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import umpaz.brewinandchewin.common.block.CheeseWheelBlock;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class DoltModHowLootTables
extends LootTableProvider {
    protected static final LootItemCondition.Builder HAS_SHEARS_TAG = CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_HARVEST);
    protected static final LootItemCondition.Builder HAS_KNIFE = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ModTags.KNIVES));
    static List<Block> BLOCK_BLACKLIST = List.of((Block)DMHBlocks.BOP_GLOW_SHROOM_COLONY.get(), (Block)DMHBlocks.TOADSTOOL_COLONY.get());

    public DoltModHowLootTables(PackOutput packOutput) {
        super(packOutput, BuiltInLootTables.m_78766_(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(DoltModHowBlockLoot::new, LootContextParamSets.f_81421_)));
    }

    protected void validate(@NotNull Map<ResourceLocation, LootTable> map, @NotNull ValidationContext context) {
    }

    public static class DoltModHowBlockLoot
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.f_50260_, Blocks.f_50273_, Blocks.f_50569_, Blocks.f_50310_, Blocks.f_50312_, Blocks.f_50316_, Blocks.f_50314_, Blocks.f_50318_, Blocks.f_50320_, Blocks.f_260630_, Blocks.f_50456_, Blocks.f_50525_, Blocks.f_50521_, Blocks.f_50522_, Blocks.f_50466_, Blocks.f_50464_, Blocks.f_50523_, Blocks.f_50460_, Blocks.f_50465_, Blocks.f_50462_, Blocks.f_50459_, Blocks.f_50458_, Blocks.f_50463_, Blocks.f_50520_, Blocks.f_50524_, Blocks.f_50457_, Blocks.f_50461_).map(ItemLike::m_5456_).collect(Collectors.toSet());

        protected DoltModHowBlockLoot() {
            super(EXPLOSION_RESISTANT, FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.m_245724_((Block)DMHBlocks.STURDY_DEEPSLATE.get());
            this.m_245724_((Block)DMHBlocks.PINE_NUTS_CRATE.get());
            this.m_246125_((Block)DMHBlocks.ALPHACENE_PATH.get(), (ItemLike)Blocks.f_50493_);
            this.colony(DMHBlocks.GLOWSHROOM_COLONY);
            this.m_246535_((Block)DMHBlocks.POTTED_TALL_BEACHGRASS.get());
            this.m_246535_((Block)DMHBlocks.POTTED_BEACHGRASS.get());
            this.m_246535_((Block)DMHBlocks.POTTED_ARID_SPROUTS.get());
            this.m_246535_((Block)DMHBlocks.POTTED_MYCELIUM_SPROUTS.get());
            this.m_246535_((Block)DMHBlocks.POTTED_STRAWBERRIES.get());
            this.m_246535_((Block)DMHBlocks.POTTED_WHITE_STRAWBERRIES.get());
            this.m_246535_((Block)DMHBlocks.POTTED_CABBAGE.get());
            this.m_246535_((Block)DMHBlocks.POTTED_ONION.get());
            this.m_246535_((Block)DMHBlocks.POTTED_TOMATOES.get());
            this.m_246481_((Block)DMHBlocks.PEWEN_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)DMHBlocks.TRAPPED_PEWEN_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)DMHBlocks.PEWEN_BOOKSHELF.get(), block -> this.m_245142_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_246481_((Block)DMHBlocks.PEWEN_BEEHIVE.get(), x$0 -> BlockLootSubProvider.m_247247_((Block)x$0));
            this.m_245724_((Block)DMHBlocks.PEWEN_LADDER.get());
            this.m_245724_((Block)DMHBlocks.PEWEN_BOARDS.get());
            this.m_246481_((Block)DMHBlocks.PEWEN_CABINET.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_245644_((Block)DMHBlocks.CHISELED_PEWEN_BOOKSHELF.get());
            this.m_246481_((Block)DMHBlocks.ANCIENT_LEAF_PILE.get(), block -> this.m_246235_((Block)block, MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS))));
            this.m_246481_((Block)DMHBlocks.THORNWOOD_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)DMHBlocks.TRAPPED_THORNWOOD_CHEST.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)DMHBlocks.THORNWOOD_CABINET.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)DMHBlocks.THORNWOOD_BEEHIVE.get(), x$0 -> BlockLootSubProvider.m_247247_((Block)x$0));
            this.m_245724_((Block)DMHBlocks.THORNWOOD_LADDER.get());
            this.m_245724_((Block)DMHBlocks.WAX_BLOCK.get());
            this.m_245724_((Block)DMHBlocks.THORNWOOD_BOARDS.get());
            this.m_246481_((Block)DMHBlocks.THORNWOOD_CABINET.get(), x$0 -> this.m_246180_((Block)x$0));
            this.m_246481_((Block)DMHBlocks.THORNWOOD_BOOKSHELF.get(), block -> this.m_245142_((Block)block, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            this.m_245644_((Block)DMHBlocks.CHISELED_THORNWOOD_BOOKSHELF.get());
            this.m_246125_((Block)DMHBlocks.ARID_RAKED_SAND.get(), (ItemLike)AtmosphericBlocks.ARID_SAND.get());
            this.m_246125_((Block)DMHBlocks.RED_ARID_RAKED_SAND.get(), (ItemLike)AtmosphericBlocks.RED_ARID_SAND.get());
            this.m_246125_((Block)DMHBlocks.ASHEN_RAKED_SAND.get(), (ItemLike)BBBlocks.ASHEN_SAND.get());
            this.m_245724_((Block)DMHBlocks.ZINC_BRICKS.get());
            this.m_245724_((Block)DMHBlocks.ZINC_BRICK_STAIRS.get());
            this.m_246481_((Block)DMHBlocks.ZINC_BRICK_SLAB.get(), x$0 -> this.m_247233_((Block)x$0));
            this.m_245724_((Block)DMHBlocks.ZINC_BRICK_WALL.get());
            this.m_245724_((Block)DMHBlocks.CHISELED_ZINC_BRICKS.get());
            this.cheese(DMHBlocks.WARDENZOLA);
            this.pipes();
        }

        private void colony(RegistryObject<? extends Block> block) {
            Object object = block.get();
            if (!(object instanceof MushroomColonyBlock)) {
                throw new IllegalArgumentException("Not mushroom colony");
            }
            MushroomColonyBlock colony = (MushroomColonyBlock)object;
            Item shroomItem = (Item)colony.mushroomType.get();
            Item colonyItem = colony.m_5456_();
            this.m_247577_((Block)block.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)colonyItem).m_79080_(DoltModHowBlockLoot.stateCond(block, MushroomColonyBlock.COLONY_AGE, 3))).m_79080_(HAS_SHEARS_TAG)}).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)shroomItem).m_230984_((Iterable)MushroomColonyBlock.COLONY_AGE.m_6908_(), value -> SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)(2.0f + (float)value.intValue())), (boolean)false).m_79080_(DoltModHowBlockLoot.stateCond(block, MushroomColonyBlock.COLONY_AGE, value)))))));
        }

        private void cheese(RegistryObject<? extends Block> wheel) {
            Object object = wheel.get();
            if (!(object instanceof CheeseWheelBlock)) {
                throw new IllegalArgumentException("Not cheese");
            }
            CheeseWheelBlock cheese = (CheeseWheelBlock)object;
            Item wedge = (Item)cheese.cheeseWedgeType.get();
            this.m_247577_((Block)wheel.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)wedge).m_230984_((Iterable)CheeseWheelBlock.SERVINGS.m_6908_(), value -> SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)(value + 1)), (boolean)false).m_79080_(DoltModHowBlockLoot.stateCond(wheel, CheeseWheelBlock.SERVINGS, value)))).m_79080_(HAS_KNIFE))));
        }

        private void pipes() {
            this.m_245724_((Block)DMHBlocks.WHITE_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.BROWN_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.GRAY_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.LIGHT_GRAY_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.RED_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.ORANGE_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.YELLOW_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.LIME_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.GREEN_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.BLUE_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.LIGHT_BLUE_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.CYAN_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.PURPLE_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.MAGENTA_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.PINK_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.BLACK_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.ROSE_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.MAROON_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.GINGER_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.TAN_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.BEIGE_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.CORAL_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.OLIVE_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.FOREST_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.VERDANT_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.AMBER_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.TEAL_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.MINT_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.AQUA_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.SLATE_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.NAVY_ENCASED_PIPE.get());
            this.m_245724_((Block)DMHBlocks.INDIGO_ENCASED_PIPE.get());
        }

        private static <V extends Comparable<V>> LootItemCondition.Builder stateCond(RegistryObject<? extends Block> block, Property<V> property, V v) {
            return LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(property, v.toString()));
        }

        @NotNull
        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.m_204297_().m_205785_().m_135782_().m_135827_().equals("dolt_mod_how")).filter(block -> !BLOCK_BLACKLIST.contains(block)).collect(Collectors.toSet());
        }
    }
}

