/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core.mixin.anchor;

import com.dolthhaven.dolt_mod_how.core.DMHConfig;
import com.dolthhaven.dolt_mod_how.core.DoltModHow;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningBolt.class})
public abstract class LightningBoltMixin
extends Entity {
    @Shadow
    protected abstract BlockPos m_147162_();

    public LightningBoltMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LightningBolt;clearCopperOnLightningStrike(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V")})
    private void DoltModHow$StruckJukeboxPlaysEpilogue(CallbackInfo ci) {
        if (!((String)DMHConfig.COMMON.discToSpawnAfterJukeboxStruckWithLightning.get()).equals("no")) {
            LightningBoltMixin.tryDoJukebox(this.m_9236_(), this.m_147162_());
        }
    }

    @Unique
    private static void logError() {
        DoltModHow.LOGGER.error("INVALID DISC DETECTED. IN THE DOLT MOD HOW CONFIG vanilla/disc/Lightning Disc FIELD.");
        DoltModHow.LOGGER.error("THAT'S EITHER NOT A DISC ITEM, OR AN INCORRECT RESOURCE LOCATION. YOU SUCK. LEARN TO TYPE IDIOT.");
        DoltModHow.LOGGER.error("Or, if it is a disc item, report to https://github.com/thelegitdolt/dolt-mod-how and I'm sorry I called you an idiot.");
    }

    @Unique
    private static void tryDoJukebox(Level level, BlockPos struckPos) {
        BlockEntity blockEntity;
        ResourceLocation discLoc = ResourceLocation.m_135820_((String)((String)DMHConfig.COMMON.discToSpawnAfterJukeboxStruckWithLightning.get()));
        if (discLoc == null) {
            LightningBoltMixin.logError();
            return;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(discLoc);
        if (!(item instanceof RecordItem)) {
            LightningBoltMixin.logError();
            return;
        }
        if (struckPos.m_123342_() > 0) {
            return;
        }
        BlockPos pos = level.m_8055_(struckPos).m_60734_() instanceof LightningRodBlock ? struckPos.m_121945_(((Direction)level.m_8055_(struckPos).m_61143_((Property)LightningRodBlock.f_52588_)).m_122424_()) : struckPos;
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof JukeboxBlock && (blockEntity = level.m_7702_(pos)) instanceof JukeboxBlockEntity) {
            JukeboxBlockEntity jukeEntity = (JukeboxBlockEntity)blockEntity;
            ItemStack stack = jukeEntity.m_8020_(0);
            if (!((Boolean)state.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue() || stack.m_150930_(item)) {
                return;
            }
            jukeEntity.m_6836_(0, new ItemStack((ItemLike)item));
        }
    }
}

