/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.core.animation;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.keyframe.BoneAnimation;
import software.bernie.geckolib.core.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.core.keyframe.event.data.ParticleKeyframeData;
import software.bernie.geckolib.core.keyframe.event.data.SoundKeyframeData;

public record Animation(String name, double length, LoopType loopType, BoneAnimation[] boneAnimations, Keyframes keyFrames) {
    static Animation generateWaitAnimation(double length) {
        return new Animation("internal.wait", length, LoopType.PLAY_ONCE, new BoneAnimation[0], new Keyframes(new SoundKeyframeData[0], new ParticleKeyframeData[0], new CustomInstructionKeyframeData[0]));
    }

    @FunctionalInterface
    public static interface LoopType {
        public static final Map<String, LoopType> LOOP_TYPES = new ConcurrentHashMap<String, LoopType>(4);
        public static final LoopType DEFAULT = (animatable, controller, currentAnimation) -> currentAnimation.loopType().shouldPlayAgain(animatable, controller, currentAnimation);
        public static final LoopType PLAY_ONCE = LoopType.register("play_once", LoopType.register("false", (animatable, controller, currentAnimation) -> false));
        public static final LoopType HOLD_ON_LAST_FRAME = LoopType.register("hold_on_last_frame", (animatable, controller, currentAnimation) -> {
            controller.animationState = AnimationController.State.PAUSED;
            return true;
        });
        public static final LoopType LOOP = LoopType.register("loop", LoopType.register("true", (animatable, controller, currentAnimation) -> true));

        public boolean shouldPlayAgain(GeoAnimatable var1, AnimationController<? extends GeoAnimatable> var2, Animation var3);

        public static LoopType fromJson(JsonElement json) {
            if (json == null || !json.isJsonPrimitive()) {
                return PLAY_ONCE;
            }
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? LOOP : PLAY_ONCE;
            }
            if (primitive.isString()) {
                return LoopType.fromString(primitive.getAsString());
            }
            return PLAY_ONCE;
        }

        default public String getId() throws IllegalStateException {
            for (String loopType : LOOP_TYPES.keySet()) {
                if (LOOP_TYPES.get(loopType) != this) continue;
                return loopType;
            }
            throw new IllegalStateException("LoopType has not been registered before being used!");
        }

        public static LoopType fromString(String name) {
            return LOOP_TYPES.getOrDefault(name, PLAY_ONCE);
        }

        public static LoopType register(String name, LoopType loopType) {
            LOOP_TYPES.put(name, loopType);
            return loopType;
        }
    }

    public record Keyframes(SoundKeyframeData[] sounds, ParticleKeyframeData[] particles, CustomInstructionKeyframeData[] customInstructions) {
    }
}

