/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.other.util;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class PaintingUtil {
    public static Optional<PaintingVariant> readStack(ItemStack stack) {
        if (!stack.m_150930_(Items.f_42487_)) {
            return Optional.empty();
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Optional.empty();
        }
        Optional painting = Painting.m_269030_((CompoundTag)tag.m_128469_("EntityTag"));
        if (painting.isPresent()) {
            return Optional.of((PaintingVariant)((Holder)painting.orElseThrow()).get());
        }
        return Optional.empty();
    }

    public static ItemStack makeStack(Supplier<PaintingVariant> variant) {
        return PaintingUtil.makeStack(variant.get());
    }

    public static ItemStack makeStack(PaintingVariant variant) {
        ItemStack paintingStack = new ItemStack((ItemLike)Items.f_42487_, 1);
        CompoundTag tag = paintingStack.m_41698_("EntityTag");
        Painting.m_269220_((CompoundTag)tag, PaintingUtil.holder(variant));
        return paintingStack;
    }

    public static List<PaintingVariant> withTag(int width, int height) {
        return PaintingUtil.withTag(width, height, false);
    }

    public static List<PaintingVariant> withTag(int width, int height, boolean includeUnplaceable) {
        return ForgeRegistries.PAINTING_VARIANTS.getValues().stream().filter(painting -> painting.m_218909_() == height && painting.m_218908_() == width).filter(painting -> includeUnplaceable || PaintingUtil.holder(painting).m_203656_(PaintingVariantTags.f_215870_)).toList();
    }

    public static Set<ItemStack> withTag(TagKey<PaintingVariant> tag) {
        return ForgeRegistries.PAINTING_VARIANTS.getValues().stream().map(PaintingUtil::holder).filter(h -> h.m_203656_(tag)).map(Holder::m_203334_).map(PaintingUtil::makeStack).collect(Collectors.toSet());
    }

    public static Holder<PaintingVariant> holder(PaintingVariant painting) {
        return (Holder)ForgeRegistries.PAINTING_VARIANTS.getHolder((Object)painting).orElseThrow();
    }

    public static Optional<Holder<PaintingVariant>> fromLanguageKey(String key) {
        String[] keys = key.split("\\.");
        return ForgeRegistries.PAINTING_VARIANTS.getHolder(new ResourceLocation(keys[1], keys[2]));
    }

    public static PaintingVariant getPainting(ResourceLocation location) {
        return (PaintingVariant)ForgeRegistries.PAINTING_VARIANTS.getValue(location);
    }
}

