/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.villagers;

import com.dolthhaven.easeldoesit.other.util.PaintingUtil;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class EaselModItemListings {

    public static class EmeraldToPainting
    extends EmeraldToItem {
        private final PaintingVariant variant;

        public EmeraldToPainting(PaintingVariant variant, UniformInt firstCount, int maxUses, int villagerXp, float priceMultiplier) {
            super(firstCount, Items.f_42487_, UniformInt.m_146622_((int)1, (int)1), maxUses, villagerXp, priceMultiplier);
            this.variant = variant;
        }

        @Override
        public ItemStack getSecond(RandomSource random, Entity entity) {
            ItemStack stack = PaintingUtil.makeStack(this.variant);
            stack.m_41764_(this.getSecondCount().m_214085_(random));
            return stack;
        }
    }

    public static class EmeraldToRandomItem
    extends EaselModTrade
    implements VillagerTrades.ItemListing {
        private final List<Item> allowedItems;

        public EmeraldToRandomItem(UniformInt firstCount, List<Item> allowedItems, UniformInt secondCount, int maxUses, int xp, float priceMultiplier) {
            super(firstCount, secondCount, maxUses, xp, priceMultiplier);
            this.allowedItems = allowedItems;
        }

        public EmeraldToRandomItem(List<Item> allowedItem, UniformInt firstCount, UniformInt secondCount) {
            this(firstCount, allowedItem, secondCount, 16, 2, 0.05f);
        }

        @Override
        public Item getFirstItem(RandomSource random, Entity entity) {
            return Items.f_42616_;
        }

        @Override
        public Item getSecondItem(RandomSource random, Entity entity) {
            return (Item)Util.m_214621_(this.allowedItems, (RandomSource)random);
        }
    }

    public static class RandomItemToEmerald
    extends EaselModTrade
    implements VillagerTrades.ItemListing {
        private final List<Item> items;

        public RandomItemToEmerald(List<Item> allowedItems, UniformInt firstCount, UniformInt secondCount, int maxUses, int xp, float priceMultiplier) {
            super(firstCount, secondCount, maxUses, xp, priceMultiplier);
            this.items = allowedItems;
        }

        public RandomItemToEmerald(List<Item> allowedItems, UniformInt firstCount, UniformInt secondCount) {
            this(allowedItems, firstCount, secondCount, 16, 2, 0.05f);
        }

        @Override
        public Item getSecondItem(RandomSource random, Entity entity) {
            return Items.f_42616_;
        }

        @Override
        public Item getFirstItem(RandomSource random, Entity entity) {
            return (Item)Util.m_214621_(this.items, (RandomSource)random);
        }
    }

    public static class EmeraldToItem
    extends EaselModTrade
    implements VillagerTrades.ItemListing {
        private final Item item;

        public EmeraldToItem(UniformInt firstCount, Item item, UniformInt secondCount, int maxUses, int villagerXp, float priceMultiplier) {
            super(firstCount, secondCount, maxUses, villagerXp, priceMultiplier);
            this.item = item;
        }

        @Override
        public Item getFirstItem(RandomSource random, Entity entity) {
            return Items.f_42616_;
        }

        @Override
        public Item getSecondItem(RandomSource random, Entity entity) {
            return this.item;
        }
    }

    public static class ItemToEmerald
    extends EaselModTrade {
        private final Item item;

        public ItemToEmerald(Item first, UniformInt firstCount, UniformInt secondCount, int maxUses, int villagerXp, float priceMultiplier) {
            super(firstCount, secondCount, maxUses, villagerXp, priceMultiplier);
            this.item = first;
        }

        public ItemToEmerald(ResourceLocation loc, UniformInt costCount, UniformInt emeraldCount, int maxUses, int villagerXp, float priceMultiplier) {
            this((Item)BuiltInRegistries.f_257033_.m_7745_(loc), costCount, emeraldCount, maxUses, villagerXp, priceMultiplier);
        }

        @Override
        public Item getFirstItem(RandomSource random, Entity entity) {
            return this.item;
        }

        @Override
        public Item getSecondItem(RandomSource random, Entity entity) {
            return Items.f_42616_;
        }
    }

    public static abstract class EaselModTrade
    implements VillagerTrades.ItemListing {
        private final UniformInt firstCount;
        private final UniformInt secondCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public EaselModTrade(UniformInt firstCount, UniformInt secondCount, int maxUses, int villagerXp, float priceMultiplier) {
            this.firstCount = firstCount;
            this.secondCount = secondCount;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = priceMultiplier;
        }

        public abstract Item getFirstItem(RandomSource var1, Entity var2);

        public abstract Item getSecondItem(RandomSource var1, Entity var2);

        public ItemStack getFirst(RandomSource random, Entity entity) {
            return new ItemStack((ItemLike)this.getFirstItem(random, entity), this.firstCount.m_214085_(random));
        }

        public UniformInt getSecondCount() {
            return this.secondCount;
        }

        public ItemStack getSecond(RandomSource random, Entity entity) {
            return new ItemStack((ItemLike)this.getSecondItem(random, entity), this.secondCount.m_214085_(random));
        }

        public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource random) {
            return new MerchantOffer(this.getFirst(random, entity), this.getSecond(random, entity), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

